/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.warp.impl.client.proxy.URLMapping;
import org.jboss.arquillian.warp.impl.utils.URLUtils;

public class DefaultURLMapping
implements URLMapping {
    private static final int BASE = 18080;
    private int sequenceNumber = 0;
    private Map<URL, URL> map = new HashMap<URL, URL>();

    public synchronized URL getProxyURL(URL url) {
        URL base = URLUtils.getUrlBase(url);
        if (this.map.containsKey(base)) {
            return this.map.get(base);
        }
        int proxyPort = this.generatePort();
        URL proxyUrl = this.newProxyUrlWithPort(base, proxyPort);
        this.map.put(base, proxyUrl);
        return proxyUrl;
    }

    private int generatePort() {
        return 18080 + this.sequenceNumber++;
    }

    private URL newProxyUrlWithPort(URL url, int port) {
        try {
            String host = this.getProxyHost();
            return new URL(url.getProtocol(), host, port, url.getFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getProxyHost() {
        return this.getProxyAddress().getHostAddress();
    }

    private InetAddress getProxyAddress() {
        return Inet4Address.getLoopbackAddress();
    }
}

