/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.warp.impl.client.event.RequireProxy;
import org.jboss.arquillian.warp.impl.client.proxy.URLMapping;
import org.jboss.arquillian.warp.impl.utils.URLUtils;
import org.jboss.arquillian.warp.spi.WarpCommons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyURLProvider
implements ResourceProvider {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Event<RequireProxy> requireProxy;
    @Inject
    private Instance<TestClass> testClass;
    private URLResourceProvider urlResourceProvider = new URLResourceProvider();

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        this.injector().inject((Object)this.urlResourceProvider);
        URL realURL = (URL)this.urlResourceProvider.lookup(resource, qualifiers);
        if ("http".equals(realURL.getProtocol()) && WarpCommons.isWarpTest((Class)((TestClass)this.testClass.get()).getJavaClass())) {
            return this.getProxyUrl(realURL);
        }
        return realURL;
    }

    private URL getProxyUrl(URL realURL) {
        URL baseRealURL = URLUtils.getUrlBase(realURL);
        URL baseProxyURL = this.urlMapping().getProxyURL(baseRealURL);
        URL proxyURL = URLUtils.buildUrl(baseProxyURL, realURL.getPath());
        this.requireProxy.fire((Object)new RequireProxy(baseRealURL, baseProxyURL));
        return proxyURL;
    }

    private Injector injector() {
        return (Injector)this.injector.get();
    }

    private URLMapping urlMapping() {
        return (URLMapping)((ServiceLoader)this.serviceLoader.get()).onlyOne(URLMapping.class);
    }
}

