/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContext;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContexts;
import org.jboss.arquillian.warp.impl.client.event.RequireProxy;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyURLToContextMapping;
import org.jboss.arquillian.warp.impl.client.proxy.RealURLToProxyURLMapping;

public class ProxyUsageTracker {
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ProxyURLToContextMapping> contextMapping;
    @Inject
    @TestScoped
    private InstanceProducer<RealURLToProxyURLMapping> realUrlMapping;
    @Inject
    private Instance<OperationalContexts> contexts;

    public void initializeContextMapping(@Observes ManagerStarted event) {
        this.contextMapping.set((Object)new ProxyURLToContextMapping());
    }

    public void initializeRealURLMapping(@Observes(precedence=1000) Before before) {
        this.realUrlMapping.set((Object)new RealURLToProxyURLMapping());
    }

    public void registerOperationalContextToUrl(@Observes RequireProxy event) {
        if (!((ProxyURLToContextMapping)this.contextMapping.get()).isRegistered(event.getProxyUrl())) {
            OperationalContext context = ((OperationalContexts)this.contexts.get()).test();
            ((ProxyURLToContextMapping)this.contextMapping.get()).register(event.getProxyUrl(), ((TestClass)this.testClass.get()).getJavaClass(), context);
        }
        if (!((RealURLToProxyURLMapping)this.realUrlMapping.get()).isRegistered(event.getRealUrl())) {
            ((RealURLToProxyURLMapping)this.realUrlMapping.get()).register(event.getRealUrl(), event.getProxyUrl());
        }
    }

    public void unregisterOperationalContext(@Observes After afterTest) {
        ((ProxyURLToContextMapping)this.contextMapping.get()).unregister(((TestClass)this.testClass.get()).getJavaClass());
    }
}

