/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.separation;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.jboss.arquillian.warp.impl.utils.ClassLoaderUtils;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparateInvocator<T> {
    private ClassLoader separatedClassLoader;
    private Class<T> clazz;
    private Class<?> separatedClass;
    private Object instance;
    private InvocationHandler handler;

    private SeparateInvocator(Class<T> clazz, ClassLoader separatedClassLoader) {
        this.separatedClassLoader = separatedClassLoader;
        this.clazz = clazz;
        this.instance = this.instantiate();
        this.handler = new SeparationHandler();
    }

    public static <I, T extends I> I invoke(Class<T> clazz, JavaArchive ... classPathArchives) {
        JavaArchive[] copy = new JavaArchive[classPathArchives.length + 1];
        System.arraycopy(classPathArchives, 0, copy, 0, classPathArchives.length);
        copy[copy.length - 1] = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(SerializationUtils.class);
        ShrinkWrapClassLoader separatedClassLoader = new ShrinkWrapClassLoader(ClassLoaderUtils.getBootstrapClassLoader(), (Archive[])copy);
        return SeparateInvocator.invoke(clazz, (ClassLoader)separatedClassLoader);
    }

    public static <I, T extends I> I invoke(Class<T> clazz, ClassLoader separatedClassLoader) {
        SeparateInvocator<T> magic = new SeparateInvocator<T>(clazz, separatedClassLoader);
        Class<?>[] interfaces = clazz.getInterfaces();
        return (I)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, magic.handler);
    }

    private static <R, T> R invokeStatic(ClassLoader separatedClassLoader, Class<T> clazz, Method method, Object ... args) {
        SeparateInvocator<T> magic = new SeparateInvocator<T>(clazz, separatedClassLoader);
        Method adoptedMethod = super.adoptMethod(method);
        Object[] adoptedArgs = super.adaptArgs(args, Thread.currentThread().getContextClassLoader(), separatedClassLoader);
        try {
            return (R)adoptedMethod.invoke(null, adoptedArgs);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke static method " + method.getName() + " from class " + clazz.getName(), e);
        }
    }

    private Method adoptMethod(Method method) {
        try {
            return this.separatedClass.getMethod(method.getName(), this.adoptMethodParameterTypes(method.getParameterTypes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find method " + method.getName() + " with arguments " + Arrays.asList(method.getParameterTypes()) + " on class " + this.separatedClass.getName() + " loaded on separated class loader");
        }
    }

    private Class<?>[] adoptMethodParameterTypes(Class<?>[] parameterTypes) {
        Class[] adopted = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                adopted[i] = this.adoptType(parameterTypes[i]);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot adopt method parameter type " + parameterTypes[i], e);
            }
        }
        return adopted;
    }

    private Class<?> adoptType(Class<?> type) {
        try {
            if (type.isPrimitive()) {
                return type;
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                Class<?> adoptedComponentType = this.adoptType(componentType);
                return Array.newInstance(adoptedComponentType, 0).getClass();
            }
            return this.loadSeparatedClassSafely(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to adopt type of " + type.getName(), e);
        }
    }

    private Object instantiate() {
        try {
            this.separatedClass = this.loadSeparatedClassSafely(this.clazz);
            return this.separatedClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate class " + this.clazz.getName() + " on separated classloader", e);
        }
    }

    private Object[] adaptArgs(Object[] args, ClassLoader from, ClassLoader to) {
        Object[] adapted = new Object[args.length];
        for (int i = 0; i < adapted.length; ++i) {
            adapted[i] = this.adapt(args[i], from, to);
        }
        return adapted;
    }

    private Object adapt(final Object object, final ClassLoader from, final ClassLoader to) {
        if (from == to) {
            return object;
        }
        if (object.getClass().getName().startsWith("java.")) {
            return object;
        }
        if (object instanceof Serializable) {
            final Method serializeMethod = SeparateInvocator.getMethodSafely(SerializationUtils.class, "serializeToBytes", Serializable.class);
            final Method deserializeMethod = SeparateInvocator.getMethodSafely(SerializationUtils.class, "deserializeFromBytes", new byte[0].getClass());
            final byte[] serialized = (byte[])new InvokeSeparately<byte[]>(){

                @Override
                public byte[] invoke() {
                    return (byte[])SeparateInvocator.invokeStatic(from, SerializationUtils.class, serializeMethod, new Object[]{object});
                }
            }.run(from);
            Object deserialized = new InvokeSeparately<Object>(){

                @Override
                public Object invoke() {
                    return SeparateInvocator.invokeStatic(to, SerializationUtils.class, deserializeMethod, new Object[]{serialized});
                }
            }.run(to);
            return deserialized;
        }
        throw new IllegalStateException("Unable to adapt instance of " + object.getClass().getName());
    }

    private static Method getMethodSafely(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain method " + methodName + " from class " + clazz.getName(), e);
        }
    }

    private Class<?> loadSeparatedClassSafely(Class<?> clazz) {
        try {
            String className = clazz.getName();
            return this.separatedClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class " + clazz.getName() + " wasn't found on separated class loader", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class InvokeSeparately<R> {
        private InvokeSeparately() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R run(ClassLoader separatedClassLoader) {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(separatedClassLoader);
                R r = this.invoke();
                return r;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }

        public abstract R invoke();
    }

    private class SeparationHandler
    implements InvocationHandler {
        private SeparationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            final Object[] adoptedArgs = SeparateInvocator.this.adaptArgs(args, contextClassLoader, SeparateInvocator.this.separatedClassLoader);
            final Method adoptedMethod = SeparateInvocator.this.adoptMethod(method);
            Object result = new InvokeSeparately<Object>(){

                @Override
                public Object invoke() {
                    try {
                        return adoptedMethod.invoke(SeparateInvocator.this.instance, adoptedArgs);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to invoke method separately", e);
                    }
                }
            }.run(SeparateInvocator.this.separatedClassLoader);
            Object adoptedResult = SeparateInvocator.this.adapt(result, SeparateInvocator.this.separatedClassLoader, contextClassLoader);
            return adoptedResult;
        }
    }
}

