/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.separation;

import org.jboss.arquillian.warp.impl.utils.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparatedClassLoader
extends ClassLoader {
    private ClassLoader[] chain;

    public SeparatedClassLoader(ClassLoader ... classLoaderChain) {
        super(ClassLoaderUtils.getBootstrapClassLoader());
        this.chain = new ClassLoader[classLoaderChain.length + 1];
        System.arraycopy(classLoaderChain, 0, this.chain, 0, classLoaderChain.length);
        this.chain[this.chain.length - 1] = super.getParent();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.chain) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException("Class with name " + name + " wasnt found in any of the class loaders in chain");
    }
}

