/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.commandBus;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.warp.impl.server.delegation.RequestDelegationService;
import org.jboss.arquillian.warp.impl.server.event.ActivateManager;
import org.jboss.arquillian.warp.impl.server.event.PassivateManager;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandPayload;
import org.jboss.arquillian.warp.impl.shared.command.OperationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBusOnServer
implements RequestDelegationService {
    public static final String COMMAND_EVENT_BUS_PATH = "CommandEventBus";
    public static final String COMMAND_EVENT_BUS_MAPPING = "/CommandEventBus";
    private static final String METHOD_NAME = "methodName";
    private static final String CLASS_NAME = "className";
    private static final String OPERATION_MODE = "operationMode";
    static ConcurrentHashMap<String, CommandPayload> events = new ConcurrentHashMap();
    static String currentCall = "";

    @Override
    public boolean canDelegate(HttpServletRequest request) {
        String path = request.getRequestURI();
        return path != null && path.endsWith(COMMAND_EVENT_BUS_MAPPING);
    }

    @Override
    public void delegate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        try {
            this.executeEvent(request, response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeEvent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            String className = null;
            String methodName = null;
            String operationMode = null;
            try {
                String eventKey;
                className = request.getParameter(CLASS_NAME);
                if (className == null) {
                    throw new IllegalArgumentException("className must be specified");
                }
                methodName = request.getParameter(METHOD_NAME);
                if (methodName == null) {
                    throw new IllegalArgumentException("methodName must be specified");
                }
                operationMode = request.getParameter(OPERATION_MODE);
                if (operationMode == null) {
                    throw new IllegalArgumentException("operationMode must be specified");
                }
                currentCall = eventKey = className + methodName;
                if (OperationMode.GET.name().equals(operationMode)) {
                    this.executeGetOperation(request, response);
                    break block7;
                }
                if (OperationMode.PUT.name().equals(operationMode)) {
                    this.executePutOperation(request, response);
                    break block7;
                }
                throw new IllegalArgumentException("Unsupported operationMode parameter.");
            }
            catch (Exception e) {
                response.sendError(500, e.getMessage());
            }
        }
    }

    private void executeGetOperation(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        if (request.getContentLength() > 0) {
            response.setStatus(204);
            ObjectInputStream input = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
            CommandPayload paylod = (CommandPayload)input.readObject();
            events.put(currentCall, paylod);
        } else if (events.containsKey(currentCall) && !events.get(currentCall).isExecuted()) {
            response.setStatus(200);
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)response.getOutputStream());
            output.writeObject(events.remove(currentCall));
            output.flush();
            output.close();
        } else {
            response.setStatus(204);
        }
    }

    private void executePutOperation(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        if (request.getContentLength() > 0) {
            ObjectInputStream input = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
            CommandPayload payload = (CommandPayload)input.readObject();
            Command operation = payload.getCommand();
            Manager manager = (Manager)request.getAttribute("org.jboss.arquillian.warp.TestManager");
            try {
                manager.fire((Object)new ActivateManager(manager));
                manager.inject((Object)operation);
                operation.perform();
                manager.fire((Object)new PassivateManager(manager));
            }
            catch (Throwable e) {
                payload.setThrowable(e);
            }
            response.setStatus(200);
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)response.getOutputStream());
            output.writeObject(payload);
            output.flush();
            output.close();
        } else {
            response.setStatus(204);
        }
    }

    public static ConcurrentHashMap<String, CommandPayload> getEvents() {
        return events;
    }

    public static String getCurrentCall() {
        return currentCall;
    }
}

