/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.delegation;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.warp.impl.server.delegation.RequestDelegationException;
import org.jboss.arquillian.warp.impl.server.delegation.RequestDelegationService;

public class RequestDelegator {
    private Logger log = Logger.getLogger(RequestDelegator.class.getName());
    private final List<RequestDelegationService> delegationServices = new ArrayList<RequestDelegationService>();

    public RequestDelegator() {
        for (RequestDelegationService service : ServiceLoader.load(RequestDelegationService.class)) {
            this.delegationServices.add(service);
        }
    }

    public boolean tryDelegateRequest(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        for (RequestDelegationService service : this.delegationServices) {
            if (!this.canDelegate(service, request)) continue;
            this.delegate(service, request, response, filterChain);
            return true;
        }
        return false;
    }

    private void delegate(RequestDelegationService service, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        try {
            service.delegate(request, response, filterChain);
        }
        catch (Exception e) {
            throw new RequestDelegationException(String.format("The request processing delegation failed: %s", e.getCause()), e);
        }
    }

    private boolean canDelegate(RequestDelegationService delegate, HttpServletRequest request) {
        try {
            return delegate.canDelegate(request);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, String.format("The delegation service can't check the delegability of the request: %s", e.getCause()), e.getCause());
            return false;
        }
    }
}

