/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.enrichment;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.warp.impl.server.enrichment.HttpResponseEnricher;
import org.jboss.arquillian.warp.impl.server.inspection.PayloadRegistry;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;

public class DefaultHttpResponseEnricher
implements HttpResponseEnricher {
    private static final Logger log = Logger.getLogger(DefaultHttpResponseEnricher.class.getName());
    @Inject
    private Instance<RequestPayload> requestPayload;
    @Inject
    private Instance<ResponsePayload> responsePayload;
    @Inject
    private Instance<HttpServletResponse> response;
    @Inject
    private Instance<PayloadRegistry> payloadRegistry;

    public void enrichResponse() {
        try {
            this.registerResponsePayload((ResponsePayload)this.responsePayload.get());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Response enrichment failed", e);
            ResponsePayload exceptionPayload = new ResponsePayload(((RequestPayload)this.requestPayload.get()).getSerialId());
            try {
                this.registerResponsePayload(exceptionPayload);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Response enrichment failed to attach enrichment failure", ex);
            }
        }
    }

    private void registerResponsePayload(ResponsePayload payload) throws IOException {
        ((PayloadRegistry)this.payloadRegistry.get()).registerResponsePayload(payload);
    }
}

