/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.execution;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.impl.server.enrichment.HttpRequestDeenricher;
import org.jboss.arquillian.warp.impl.server.enrichment.HttpResponseEnricher;
import org.jboss.arquillian.warp.impl.server.event.EnrichHttpResponse;
import org.jboss.arquillian.warp.impl.server.event.ProcessHttpRequest;
import org.jboss.arquillian.warp.impl.server.event.ProcessWarpRequest;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.context.RequestScoped;

public class HttpRequestProcessor {
    @Inject
    private Event<ProcessWarpRequest> processWarpRequest;
    @Inject
    @RequestScoped
    private InstanceProducer<RequestPayload> requestPayload;
    @Inject
    @RequestScoped
    private InstanceProducer<ResponsePayload> responsePayload;

    public void processHttpRequest(@Observes ProcessHttpRequest event, ServiceLoader services, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.responsePayload.set((Object)new ResponsePayload(-1L));
        HttpRequestDeenricher requestDeenricher = (HttpRequestDeenricher)services.onlyOne(HttpRequestDeenricher.class);
        if (requestDeenricher.isEnriched()) {
            RequestPayload p = (RequestPayload)requestDeenricher.resolvePayload();
            long serialId = p.getSerialId();
            this.responsePayload.set((Object)new ResponsePayload(serialId));
            response.setHeader("X-Arq-Enrichment-Response", Long.toString(serialId));
            this.requestPayload.set((Object)p);
            this.processWarpRequest.fire((Object)new ProcessWarpRequest());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void enrichHttpResponse(@Observes EnrichHttpResponse event, ServiceLoader services) {
        HttpResponseEnricher responseEnricher = (HttpResponseEnricher)services.onlyOne(HttpResponseEnricher.class);
        responseEnricher.enrichResponse();
    }
}

