/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.execution;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ManagerBuilder;
import org.jboss.arquillian.warp.impl.server.delegation.RequestDelegator;
import org.jboss.arquillian.warp.impl.server.event.ActivateManager;
import org.jboss.arquillian.warp.impl.server.event.PassivateManager;
import org.jboss.arquillian.warp.impl.server.event.ProcessHttpRequest;
import org.jboss.arquillian.warp.spi.context.RequestScoped;
import org.jboss.arquillian.warp.spi.event.AfterRequest;
import org.jboss.arquillian.warp.spi.event.BeforeRequest;

@WebFilter(urlPatterns={"/*"}, asyncSupported=true)
public class WarpFilter
implements Filter {
    public static final String ARQUILLIAN_MANAGER_ATTRIBUTE = "org.jboss.arquillian.warp.TestManager";
    private static final String DEFAULT_EXTENSION_CLASS = "org.jboss.arquillian.core.impl.loadable.LoadableExtensionLoader";
    private Logger log = Logger.getLogger(WarpFilter.class.getSimpleName());
    private RequestDelegator delegator;
    private Manager manager;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.log.log(Level.FINE, "initializing {0}", WarpFilter.class.getSimpleName());
            ManagerBuilder builder = ManagerBuilder.from().extension(Class.forName(DEFAULT_EXTENSION_CLASS));
            this.manager = builder.create();
            this.manager.start();
            this.manager.bind(ApplicationScoped.class, Manager.class, (Object)this.manager);
            this.delegator = new RequestDelegator();
        }
        catch (Exception e) {
            throw new ServletException("Could not init " + WarpFilter.class.getSimpleName(), (Throwable)e);
        }
    }

    public void destroy() {
        this.manager.shutdown();
        this.manager = null;
        this.delegator = null;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.manager == null || this.isHttpRequest(req, resp)) {
            this.doFilterHttp((HttpServletRequest)req, (HttpServletResponse)resp, chain);
        } else {
            chain.doFilter(req, resp);
        }
    }

    private boolean isHttpRequest(ServletRequest req, ServletResponse resp) {
        return req instanceof HttpServletRequest && resp instanceof HttpServletResponse;
    }

    private void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request.setAttribute(ARQUILLIAN_MANAGER_ATTRIBUTE, (Object)this.manager);
        boolean isDelegated = this.delegator.tryDelegateRequest(request, response, filterChain);
        if (!isDelegated) {
            this.doFilterWarp(request, response, filterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterWarp(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.manager.fire((Object)new ActivateManager(this.manager));
        this.manager.fire((Object)new BeforeRequest((ServletRequest)request, (ServletResponse)response));
        this.manager.bind(RequestScoped.class, ServletRequest.class, (Object)request);
        this.manager.bind(RequestScoped.class, ServletResponse.class, (Object)response);
        this.manager.bind(RequestScoped.class, HttpServletRequest.class, (Object)request);
        this.manager.bind(RequestScoped.class, HttpServletResponse.class, (Object)response);
        this.manager.bind(RequestScoped.class, FilterChain.class, (Object)filterChain);
        try {
            this.manager.fire((Object)new ProcessHttpRequest());
        }
        finally {
            this.manager.fire((Object)new AfterRequest((ServletRequest)request, (ServletResponse)response));
        }
        this.manager.fire((Object)new PassivateManager(this.manager));
    }
}

