/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.execution;

import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.server.event.ExecuteWarp;
import org.jboss.arquillian.warp.impl.server.event.WarpLifecycleFinished;
import org.jboss.arquillian.warp.impl.server.event.WarpLifecycleStarted;
import org.jboss.arquillian.warp.impl.server.inspection.InspectionRegistry;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.LifecycleManager;
import org.jboss.arquillian.warp.spi.servlet.event.AfterServlet;
import org.jboss.arquillian.warp.spi.servlet.event.BeforeServlet;

public class WarpLifecycle {
    @Inject
    private Instance<LifecycleManager> lifecycleManager;
    @Inject
    private Instance<InspectionRegistry> inspectionRegistry;
    @Inject
    private Event<WarpLifecycleStarted> warpLifecycleStarted;
    @Inject
    private Event<WarpLifecycleFinished> warpLifecycleFinished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Observes ExecuteWarp event, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, RequestPayload requestPayload, ResponsePayload responsePayload) throws Throwable {
        List<Inspection> inspections = requestPayload.getInspections();
        try {
            ((LifecycleManager)this.lifecycleManager.get()).bindTo(ServletRequest.class, (Object)request);
            ((InspectionRegistry)this.inspectionRegistry.get()).registerInspections(inspections);
            this.warpLifecycleStarted.fire((Object)new WarpLifecycleStarted());
            ((LifecycleManager)this.lifecycleManager.get()).fireEvent((Object)new BeforeServlet());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            ((LifecycleManager)this.lifecycleManager.get()).fireEvent((Object)new AfterServlet());
            responsePayload.setInspections(inspections);
        }
        finally {
            this.warpLifecycleFinished.fire((Object)new WarpLifecycleFinished());
            ((InspectionRegistry)this.inspectionRegistry.get()).unregisterInspections(inspections);
            ((LifecycleManager)this.lifecycleManager.get()).unbindFrom(ServletRequest.class, (Object)request);
        }
    }
}

