/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.execution;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.impl.server.event.EnrichHttpResponse;
import org.jboss.arquillian.warp.impl.server.event.ExecuteWarp;
import org.jboss.arquillian.warp.impl.server.event.ProcessWarpRequest;
import org.jboss.arquillian.warp.impl.server.event.RequestProcessingFinished;
import org.jboss.arquillian.warp.impl.server.event.RequestProcessingStarted;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class WarpRequestProcessor {
    private Logger log = Logger.getLogger(WarpRequestProcessor.class.getName());
    @Inject
    private Event<RequestProcessingStarted> requestProcessingStarted;
    @Inject
    private Event<RequestProcessingFinished> requestProcessingFinished;
    @Inject
    private Event<EnrichHttpResponse> enrichHttpResponse;
    @Inject
    private Event<ExecuteWarp> executeWarp;
    @Inject
    private Event<TestResult> testResult;

    public void processWarpRequest(@Observes ProcessWarpRequest event, HttpServletResponse response, ResponsePayload responsePayload) throws IOException {
        this.requestProcessingStarted.fire((Object)new RequestProcessingStarted());
        try {
            this.executeWarp.fire((Object)new ExecuteWarp());
        }
        catch (Throwable e) {
            this.testResult.fire((Object)new TestResult(TestResult.Status.FAILED, e));
        }
        if (responsePayload.getTestResult() != null) {
            if (responsePayload.getTestResult().getThrowable() != null && WarpCommons.debugMode()) {
                this.log.log(Level.SEVERE, "exception was thrown during Warp execution", responsePayload.getTestResult().getThrowable());
            }
        } else {
            responsePayload.setTestResult(new TestResult(TestResult.Status.PASSED));
        }
        try {
            this.enrichHttpResponse.fire((Object)new EnrichHttpResponse());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Warp failed to enrich HTTP response", e);
        }
        this.requestProcessingFinished.fire((Object)new RequestProcessingFinished());
    }
}

