/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.lifecycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.spi.LifecycleManager;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.exception.ObjectAlreadyAssociatedException;
import org.jboss.arquillian.warp.spi.exception.ObjectNotAssociatedException;
import org.jboss.arquillian.warp.spi.exception.StoreHasAssociatedObjectsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerStoreImpl
extends LifecycleManagerStore {
    private static ConcurrentHashMap<Class<?>, Binding> STORE = new ConcurrentHashMap();
    private static ConcurrentHashMap<LifecycleManager, Tracking> TRACK = new ConcurrentHashMap();

    protected <T> LifecycleManager obtain(Class<T> clazz, T boundObject) throws ObjectNotAssociatedException {
        Validate.notNull(boundObject, (String)"boundObject must not be null");
        Binding binding = STORE.get(clazz);
        if (binding == null) {
            throw new ObjectNotAssociatedException();
        }
        LifecycleManager manager = (LifecycleManager)binding.get(boundObject);
        if (manager == null) {
            throw new ObjectNotAssociatedException();
        }
        return manager;
    }

    protected <T> void bind(LifecycleManager manager, Class<T> clazz, T object) throws ObjectAlreadyAssociatedException {
        STORE.putIfAbsent(clazz, new Binding());
        Binding binding = STORE.get(clazz);
        if (binding.put(object, manager) != null) {
            throw new ObjectAlreadyAssociatedException();
        }
        TRACK.putIfAbsent(manager, new Tracking());
        Tracking tracking = TRACK.get(manager);
        tracking.add(clazz);
    }

    protected <T> void unbind(LifecycleManager manager, Class<T> clazz, T object) throws ObjectNotAssociatedException {
        Binding binding = STORE.get(clazz);
        if (binding == null) {
            throw new ObjectNotAssociatedException();
        }
        if (!binding.containsKey(object)) {
            throw new ObjectNotAssociatedException();
        }
        binding.remove(object);
        Tracking tracking = TRACK.get(manager);
        tracking.remove(clazz);
    }

    protected <T> void checkUnbound(LifecycleManager manager) throws StoreHasAssociatedObjectsException {
        Tracking tracking = TRACK.get(manager);
        if (tracking != null) {
            if (!tracking.isEmpty()) {
                throw new StoreHasAssociatedObjectsException();
            }
            TRACK.remove(manager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tracking
    extends HashSet<Class<?>> {
        private Tracking() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Binding
    extends HashMap<Object, LifecycleManager> {
        private Binding() {
        }
    }
}

