/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.server.inspection.InspectionRegistry;
import org.jboss.arquillian.warp.impl.server.test.LifecycleMethodExecutor;
import org.jboss.arquillian.warp.impl.server.test.SecurityActions;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.WarpLifecycleEvent;
import org.jboss.arquillian.warp.spi.WarpLifecycleTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleTestDriver {
    @Inject
    private Instance<InspectionRegistry> registry;
    @Inject
    private Event<Before> before;
    @Inject
    private Event<After> after;
    @Inject
    private Event<Test> test;

    public void fireTest(@Observes WarpLifecycleEvent event) {
        for (Inspection inspection : this.registry().getInspections()) {
            List qualifiers = event.getQualifiers();
            if (qualifiers == null || qualifiers.size() == 0 || !this.isWarpLifecycleEvent(qualifiers)) {
                throw new IllegalStateException("Warp lifecycle event must contain annotation marked with @" + WarpLifecycleTest.class.getSimpleName());
            }
            List<Method> methods = SecurityActions.getMethodsMatchingAllQualifiers(inspection.getClass(), qualifiers);
            for (Method testMethod : methods) {
                this.executeTest(inspection, testMethod, qualifiers);
            }
        }
    }

    private boolean isWarpLifecycleEvent(List<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (WarpCommons.isWarpLifecycleTest(qualifier.annotationType())) continue;
            return false;
        }
        return true;
    }

    private void executeTest(Object inspection, Method method, List<Annotation> qualifiers) {
        this.before.fire((Object)new Before(inspection, method));
        this.test.fire((Object)new Test((TestMethodExecutor)new LifecycleMethodExecutor(inspection, method, qualifiers)));
        this.after.fire((Object)new After(inspection, method));
    }

    private InspectionRegistry registry() {
        return (InspectionRegistry)this.registry.get();
    }
}

