/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.test;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;

public class TestResultObserver {
    @Inject
    private Instance<ResponsePayload> responsePayload;

    public void propagateTestResult(@Observes TestResult testResult) {
        this.storeFirstFailure(testResult);
    }

    public void propagateThrowableAsTestResultAndRethrow(@Observes Throwable throwable) throws Throwable {
        if (this.responsePayload() != null) {
            this.storeFirstFailure(new TestResult(TestResult.Status.FAILED, throwable));
        }
        throw throwable;
    }

    private void storeFirstFailure(TestResult testResult) {
        if (testResult.getStatus() != TestResult.Status.PASSED && this.responsePayload().getTestResult() == null) {
            this.responsePayload().setTestResult(testResult);
        }
    }

    private ResponsePayload responsePayload() {
        return (ResponsePayload)this.responsePayload.get();
    }
}

