/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.shared;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.impl.shared.SerializedAnnotation;
import org.jboss.arquillian.warp.impl.shared.SerializedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutedMethod
implements Externalizable {
    private Method method;
    private List<Annotation> qualifiers;

    public ExecutedMethod() {
    }

    public ExecutedMethod(Method method, List<Annotation> qualifiers) {
        Validate.notNull((Object)method, (String)"method must not be null");
        Validate.notNull(qualifiers, (String)"qualifiers must not be null");
        this.method = method;
        this.qualifiers = qualifiers;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public List<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<Annotation> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutedMethod other = (ExecutedMethod)obj;
        if (this.qualifiers == null && other.qualifiers != null) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new SerializedMethod(this.method));
        out.writeInt(this.qualifiers.size());
        for (Annotation qualifier : this.qualifiers) {
            out.writeObject(new SerializedAnnotation(qualifier));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.method = ((SerializedMethod)in.readObject()).getMethod();
        int size = in.readInt();
        this.qualifiers = new ArrayList<Annotation>(size);
        for (int i = 0; i < size; ++i) {
            this.qualifiers.add(((SerializedAnnotation)in.readObject()).getAnnotation());
        }
    }
}

