/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.warp.client.execution.WarpActivityBuilder;
import org.jboss.arquillian.warp.client.execution.WarpRuntime;
import org.jboss.arquillian.warp.client.filter.http.HttpFilterBuilder;
import org.jboss.arquillian.warp.impl.client.execution.DefaultWarpRuntime;
import org.jboss.arquillian.warp.impl.client.execution.WarpRequestSpecifier;
import org.jboss.arquillian.warp.impl.utils.WarpTestValidator;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class WarpRuntimeInitializer {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void injectWarpRuntime(@Observes BeforeClass event) {
        TestClass testClass = event.getTestClass();
        if (!WarpCommons.isWarpTest((Class)testClass.getJavaClass())) return;
        if (!WarpTestValidator.isAnnotatedRunAsClient(testClass)) throw new IllegalArgumentException("You are trying to run a Warp test " + testClass.getJavaClass() + " which is NOT annotated by the annotation: @RunAsClient. Add the annotation and try it again.");
        if (!WarpTestValidator.hasTestableDeployment(testClass)) throw new IllegalArgumentException("The test " + testClass.getJavaClass() + " doesn't have declared any deployment or none of the declared deloyments is testable. Check that you have a deployment annotated by @Deployment(testable=true) and try it again.");
        DefaultWarpRuntime runtime = new DefaultWarpRuntime();
        runtime.setWarpActivityBuilder((WarpActivityBuilder)((ServiceLoader)this.serviceLoader.get()).onlyOne(WarpRequestSpecifier.class));
        runtime.setHttpFilterBuilder((HttpFilterBuilder)((ServiceLoader)this.serviceLoader.get()).onlyOne(HttpFilterBuilder.class));
        WarpRuntime.setInstance((WarpRuntime)runtime);
    }

    public void cleanWarpRuntime(@Observes AfterClass event) {
        WarpRuntime.setInstance(null);
    }
}

