/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.commandBus;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.warp.impl.client.commandBus.CommandBusObserver;
import org.jboss.arquillian.warp.impl.client.context.operation.ContextualOperation;
import org.jboss.arquillian.warp.impl.client.context.operation.Contextualizer;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContext;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContexts;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandPayload;
import org.jboss.arquillian.warp.impl.shared.command.OperationMode;
import org.jboss.arquillian.warp.impl.utils.Rethrow;
import org.jboss.arquillian.warp.spi.WarpCommons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBusOnClient {
    private final Logger log = Logger.getLogger(CommandBusOnClient.class.getName());
    @Inject
    private Event<Object> eventExecutedRemotely;
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;
    @Inject
    private Instance<OperationalContexts> operationalContexts;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<TestClass> testClass;
    private String channelUrl;
    private static Timer eventBusTimer;

    public void startBus(CommandBusObserver.StartBus event) {
        String url;
        if (!WarpCommons.isWarpTest((Class)((TestClass)this.testClass.get()).getJavaClass())) {
            return;
        }
        if (this.protocolMetadata.get() == null) {
            this.log.warning("There is no protocol metadata - possible causes: URL wasn't resolved because of some failure or there is no testable deployment");
            return;
        }
        Class<?> testClass = event.getTestInstance().getClass();
        Method testMethod = event.getTestMethod();
        Collection contexts = ((ProtocolMetaData)this.protocolMetadata.get()).getContexts(HTTPContext.class);
        HTTPContext context = this.locateHTTPContext(testMethod, contexts);
        URI servletURI = this.locateCommandEventBusURI(context);
        this.channelUrl = url = servletURI.toASCIIString() + "?className=" + testClass.getName() + "&methodName=" + testMethod.getName();
        final String eventUrlForGet = url + "&operationMode=" + OperationMode.GET.name();
        final ContextualOperation<Command, Void> operation = this.operationForExecutingEventRemotelyOnCurrentContext();
        if (eventBusTimer != null) {
            eventBusTimer.cancel();
        }
        try {
            eventBusTimer = new Timer();
            eventBusTimer.schedule(new TimerTask(){

                public void run() {
                    block4: {
                        try {
                            CommandPayload payload = (CommandPayload)CommandBusOnClient.this.execute(eventUrlForGet, CommandPayload.class, null);
                            if (payload == null) break block4;
                            Command command = payload.getCommand();
                            try {
                                operation.performInContext(command);
                            }
                            catch (Throwable e) {
                                payload.setThrowable(e);
                            }
                            payload.setExecuted();
                            CommandBusOnClient.this.execute(eventUrlForGet, Object.class, payload);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, 0L, 100L);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethod, e);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopBus() {
        if (eventBusTimer != null) {
            eventBusTimer.cancel();
            eventBusTimer = null;
        }
    }

    private ContextualOperation<Command, Void> operationForExecutingEventRemotelyOnCurrentContext() {
        OperationalContext context = ((OperationalContexts)this.operationalContexts.get()).test();
        return Contextualizer.contextualize(context, new ContextualOperation<Command, Void>(){

            @Override
            public Void performInContext(Command command) {
                ((Injector)CommandBusOnClient.this.injector.get()).inject((Object)command);
                command.perform();
                return null;
            }
        }, ContextualOperation.class, new Class[0]);
    }

    public Command executeRemotely(Command command) {
        String eventUrlForPut = this.channelUrl + "&operationMode=" + OperationMode.PUT.name();
        CommandPayload payload = new CommandPayload(command);
        try {
            CommandPayload result = this.execute(eventUrlForPut, CommandPayload.class, payload);
            if (result.getThrowable() != null) {
                Rethrow.asUnchecked(result.getThrowable());
            }
            return result.getCommand();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error executing remote command", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(String url, Class<T> returnType, Object requestObject) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalStateException("Not an http connection! " + connection);
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setUseCaches(false);
        httpConnection.setDefaultUseCaches(false);
        httpConnection.setDoInput(true);
        httpConnection.setInstanceFollowRedirects(false);
        try {
            ObjectInputStream ois;
            if (requestObject != null) {
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            if (requestObject != null) {
                ObjectOutputStream ous = new ObjectOutputStream(httpConnection.getOutputStream());
                try {
                    ous.writeObject(requestObject);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error sending request Object, " + requestObject, e2);
                }
                finally {
                    ous.flush();
                    ous.close();
                }
            }
            try {
                httpConnection.getResponseCode();
            }
            catch (ConnectException e) {
                T e2 = null;
                httpConnection.disconnect();
                return e2;
            }
            if (httpConnection.getResponseCode() == 200) {
                Object o;
                ois = new ObjectInputStream(httpConnection.getInputStream());
                try {
                    o = ois.readObject();
                }
                finally {
                    ois.close();
                }
                if (!returnType.isInstance(o)) {
                    throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + o);
                }
                T t = returnType.cast(o);
                return t;
            }
            if (httpConnection.getResponseCode() == 204) {
                ois = null;
                return (T)ois;
            }
            if (httpConnection.getResponseCode() == 302) {
                String redirectUrl = httpConnection.getHeaderField("Location");
                T t = this.execute(redirectUrl, returnType, requestObject);
                return t;
            }
            if (httpConnection.getResponseCode() != 404) {
                throw new IllegalStateException("Error launching test at " + url + ". Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
            }
        }
        finally {
            httpConnection.disconnect();
        }
        return null;
    }

    private HTTPContext locateHTTPContext(Method method, Collection<HTTPContext> contexts) {
        TargetsContainer targetContainer = method.getAnnotation(TargetsContainer.class);
        if (targetContainer != null) {
            String targetName = targetContainer.value();
            for (HTTPContext context : contexts) {
                if (!targetName.equals(context.getName())) continue;
                return context;
            }
            throw new IllegalArgumentException("Could not determin HTTPContext from ProtocolMetadata for target: " + targetName + ". Verify that the given target name in @" + TargetsContainer.class.getSimpleName() + " match a name returned by the deployment container");
        }
        return contexts.toArray(new HTTPContext[0])[0];
    }

    private URI locateCommandEventBusURI(HTTPContext context) {
        List contextServlets = context.getServlets();
        if (contextServlets == null) {
            throw new IllegalArgumentException("Could not determine URI for WarpFilter in context " + context + ". There are no Servlets in context.");
        }
        HashSet<String> contextRoots = new HashSet<String>();
        for (Servlet servlet : contextServlets) {
            contextRoots.add(servlet.getContextRoot());
        }
        if (contextRoots.size() == 1) {
            try {
                URI baseURI = ((Servlet)context.getServlets().get(0)).getBaseURI();
                String path = baseURI.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                path = path + "/CommandEventBus";
                return new URI("http", null, baseURI.getHost(), baseURI.getPort(), path, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not convert Servlet to URL, " + context.getServlets().get(0), e);
            }
        }
        try {
            return new URI("http", null, context.getHost(), context.getPort(), "/CommandEventBus", null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not convert HTTPContext to URL, " + context, e);
        }
    }
}

