/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.commandBus;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandService;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class RemoteSuiteLifecyclePropagation {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    void sendBefore(@Observes Before event) throws Exception {
        if (WarpCommons.isWarpTest((Class)event.getTestClass().getJavaClass())) {
            this.remoteOperationService().execute(new FireBeforeSuiteOnServer());
        }
    }

    void sendAfter(@Observes After event) throws Exception {
        if (WarpCommons.isWarpTest((Class)event.getTestClass().getJavaClass())) {
            this.remoteOperationService().execute(new FireAfterSuiteOnServer());
        }
    }

    private CommandService remoteOperationService() {
        return (CommandService)((ServiceLoader)this.serviceLoader.get()).onlyOne(CommandService.class);
    }

    public static class FireAfterSuiteOnServer
    implements Command {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient Event<AfterSuite> afterSuite;

        public void perform() {
            this.afterSuite.fire((Object)new AfterSuite());
        }
    }

    public static class FireBeforeSuiteOnServer
    implements Command {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient Event<BeforeSuite> beforeSuite;

        public void perform() {
            this.beforeSuite.fire((Object)new BeforeSuite());
        }
    }
}

