/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.deployment;

import java.io.InputStream;
import java.util.Collection;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.WarpRemoteExtension;
import org.jboss.arquillian.warp.impl.client.commandBus.RemoteSuiteLifecyclePropagation;
import org.jboss.arquillian.warp.impl.client.execution.DefaultHttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.execution.DefaultResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.server.commandBus.CommandBusOnServer;
import org.jboss.arquillian.warp.impl.server.delegation.RequestDelegationService;
import org.jboss.arquillian.warp.impl.server.lifecycle.LifecycleManagerStoreImpl;
import org.jboss.arquillian.warp.servlet.AfterServlet;
import org.jboss.arquillian.warp.servlet.BeforeServlet;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.WarpDeploymentEnrichmentExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentEnricher
implements ProtocolArchiveProcessor {
    static String[] REQUIRED_WARP_PACKAGES = new String[]{"org.jboss.arquillian.warp.spi", "org.jboss.arquillian.warp.spi.context", "org.jboss.arquillian.warp.spi.event", "org.jboss.arquillian.warp.spi.exception", "org.jboss.arquillian.warp.spi.servlet.event", "org.jboss.arquillian.warp.impl.server.inspection", "org.jboss.arquillian.warp.impl.server.enrichment", "org.jboss.arquillian.warp.impl.server.event", "org.jboss.arquillian.warp.impl.server.manager", "org.jboss.arquillian.warp.impl.server.execution", "org.jboss.arquillian.warp.impl.server.lifecycle", "org.jboss.arquillian.warp.impl.server.provider", "org.jboss.arquillian.warp.impl.server.request", "org.jboss.arquillian.warp.impl.server.test", "org.jboss.arquillian.warp.impl.server.commandBus", "org.jboss.arquillian.warp.impl.server.delegation", "org.jboss.arquillian.warp.impl.server.remote", "org.jboss.arquillian.warp.impl.shared", "org.jboss.arquillian.warp.impl.shared.command", "org.jboss.arquillian.warp.impl.utils", "org.jboss.arquillian.warp.servlet.event", "org.jboss.arquillian.warp.servlet.provider"};
    static final String WARP_FILTER_CLASS_FQN = "org.jboss.arquillian.warp.impl.server.execution.WarpFilter";
    static Class<?>[] REQUIRED_WARP_INNER_CLASSES = new Class[]{RemoteSuiteLifecyclePropagation.FireBeforeSuiteOnServer.class, RemoteSuiteLifecyclePropagation.FireAfterSuiteOnServer.class, DefaultHttpRequestEnrichmentService.RegisterPayloadRemotely.class, DefaultResponseDeenrichmentService.RetrievePayloadFromServer.class};
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<TestClass> testClass;

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        TestClass testClass = (TestClass)this.testClass.get();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        if (WarpCommons.isWarpTest((Class)testClass.getJavaClass())) {
            if (!Validate.isArchiveOfType(WebArchive.class, protocolArchive)) {
                throw new IllegalArgumentException("Protocol archives of type " + protocolArchive.getClass() + " not supported by Warp. Please use the Servlet 3.0 protocol.");
            }
            this.addWarpPackageToDeployment((WebArchive)protocolArchive.as(WebArchive.class));
            this.addWarpExtensionsDeployment((WebArchive)protocolArchive.as(WebArchive.class));
            this.removeTestClassFromDeployment(applicationArchive, testClass);
        }
    }

    private void addWarpPackageToDeployment(WebArchive archive) {
        archive.addAsLibrary((Archive)this.createWarpArchive());
    }

    private void addWarpExtensionsDeployment(WebArchive archive) {
        Collection lifecycleExtensions = ((ServiceLoader)this.serviceLoader.get()).all(WarpDeploymentEnrichmentExtension.class);
        for (WarpDeploymentEnrichmentExtension extension : lifecycleExtensions) {
            JavaArchive library = extension.getEnrichmentLibrary();
            if (library != null) {
                archive.addAsLibrary((Archive)library);
            }
            extension.enrichWebArchive(archive);
        }
    }

    private void removeTestClassFromDeployment(Archive<?> archive, TestClass testClass) {
        for (ArchivePath archivePath : archive.getContent().keySet()) {
            String path = archivePath.get();
            String classPath = testClass.getName().replace(".", "/");
            if (!path.matches("/WEB-INF/classes/" + classPath + "(\\$[0-9]*)?\\.class")) continue;
            archive.delete(archivePath);
        }
    }

    JavaArchive createWarpArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-warp.jar");
        archive.addClass(Inspection.class);
        archive.addClasses(new Class[]{BeforeServlet.class, AfterServlet.class});
        for (String packageName : REQUIRED_WARP_PACKAGES) {
            archive.addPackage(packageName);
        }
        archive.addAsManifestResource(this.getWebFragmentAsset(), "web-fragment.xml");
        archive.addClasses((Class[])REQUIRED_WARP_INNER_CLASSES);
        archive.addClass(WarpRemoteExtension.class);
        archive.addAsServiceProvider(RemoteLoadableExtension.class.getName(), new String[]{WarpRemoteExtension.class.getName(), "!org.jboss.arquillian.protocol.servlet.runner.ServletRemoteExtension"});
        archive.addAsServiceProvider(LifecycleManagerStore.class, new Class[]{LifecycleManagerStoreImpl.class});
        archive.addAsServiceProvider(RequestDelegationService.class, new Class[]{CommandBusOnServer.class});
        return archive;
    }

    private Asset getWebFragmentAsset() {
        return new Asset(){

            public InputStream openStream() {
                return ClassLoader.getSystemResourceAsStream("META-INF/web-fragment-warp.xml");
            }
        };
    }
}

