/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.warp.Warp;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpRequest;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpResponse;
import org.jboss.arquillian.warp.impl.client.event.TransformHttpResponse;
import org.jboss.arquillian.warp.impl.client.execution.HttpRequestWrapper;
import org.jboss.arquillian.warp.impl.client.execution.SynchronizationPoint;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.client.scope.WarpExecutionScoped;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;

public class DefaultHttpFiltersSource
extends HttpFiltersSourceAdapter {
    private static final int MAX_BUFFER_SIZE_IN_BYTES = 0x500000;
    private Logger log = Logger.getLogger(Warp.class.getName());
    @Inject
    private Event<FilterHttpRequest> tryEnrichRequest;
    @Inject
    private Event<FilterHttpResponse> tryDeenrichResponse;
    @Inject
    @WarpExecutionScoped
    private InstanceProducer<HttpResponse> responseInstance;
    @Inject
    private Event<TransformHttpResponse> transformHttpResponse;

    public HttpFilters filterRequest(HttpRequest originalRequest) {
        return new HttpFiltersAdapter(originalRequest){
            private HttpRequest request;

            public HttpResponse requestPost(HttpObject httpObject) {
                WarpContext context = WarpContextStore.get();
                if (httpObject instanceof HttpRequest) {
                    this.request = (HttpRequest)httpObject;
                }
                if (context == null) {
                    return null;
                }
                try {
                    SynchronizationPoint synchronization = context.getSynchronization();
                    if (synchronization.isWaitingForRequests() && httpObject instanceof HttpRequest) {
                        DefaultHttpFiltersSource.this.tryEnrichRequest.fire((Object)new FilterHttpRequest(new HttpRequestWrapper(this.request)));
                    }
                }
                catch (Exception originalException) {
                    ClientWarpExecutionException explainingException = new ClientWarpExecutionException("enriching request failed: " + originalException.getMessage(), (Throwable)originalException);
                    context.pushException((Exception)explainingException);
                }
                return null;
            }

            public HttpObject responsePost(HttpObject httpObject) {
                try {
                    if (this.request instanceof HttpRequest && httpObject instanceof HttpResponse) {
                        HttpResponse response = (HttpResponse)httpObject;
                        DefaultHttpFiltersSource.this.tryDeenrichResponse.fire((Object)new FilterHttpResponse(this.request, response));
                        TransformHttpResponse transformEvent = new TransformHttpResponse(this.request, response);
                        DefaultHttpFiltersSource.this.transformHttpResponse.fire((Object)transformEvent);
                        return transformEvent.getResponse();
                    }
                }
                catch (Exception originalException) {
                    WarpContext context = WarpContextStore.get();
                    if (context == null) {
                        DefaultHttpFiltersSource.this.log.log(Level.WARNING, originalException.getMessage(), originalException);
                        return httpObject;
                    }
                    ClientWarpExecutionException explainingException = new ClientWarpExecutionException("deenriching response failed: " + originalException.getMessage(), (Throwable)originalException);
                    context.pushException((Exception)explainingException);
                }
                return httpObject;
            }
        };
    }

    public int getMaximumRequestBufferSizeInBytes() {
        return 0x500000;
    }

    public int getMaximumResponseBufferSizeInBytes() {
        return 0x500000;
    }
}

