/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.Activity;
import org.jboss.arquillian.warp.client.result.WarpResult;
import org.jboss.arquillian.warp.exception.ServerWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.event.AdvertiseEnrichment;
import org.jboss.arquillian.warp.impl.client.event.AwaitResponse;
import org.jboss.arquillian.warp.impl.client.event.CleanEnrichment;
import org.jboss.arquillian.warp.impl.client.event.FinishEnrichment;
import org.jboss.arquillian.warp.impl.client.execution.DefaultWarpRequestSpecifier;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpExecutor;
import org.jboss.arquillian.warp.impl.utils.Rethrow;

public class DefaultWarpExecutor
implements WarpExecutor {
    @Inject
    private Event<AdvertiseEnrichment> advertiseEnrichment;
    @Inject
    private Event<FinishEnrichment> finishEnrichment;
    @Inject
    private Event<CleanEnrichment> cleanEnrichment;
    @Inject
    private Event<AwaitResponse> awaitResponse;
    @Inject
    private Event<Activity> executeActivity;
    private RuntimeException activityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarpResult execute(Activity activity, WarpContext warpContext) {
        try {
            this.setupServerInspection();
            this.executeActivity(activity);
            this.awaitServerExecution(warpContext);
            this.checkActivityFailure();
            WarpResult warpResult = warpContext.getResult();
            return warpResult;
        }
        finally {
            this.cleanup();
        }
    }

    private void setupServerInspection() {
        this.advertiseEnrichment.fire((Object)new AdvertiseEnrichment());
        this.finishEnrichment.fire((Object)new FinishEnrichment());
    }

    private void executeActivity(Activity activity) {
        this.activityException = null;
        try {
            this.executeActivity.fire((Object)activity);
        }
        catch (Throwable e) {
            this.activityException = new DefaultWarpRequestSpecifier.ActivityException(e);
        }
    }

    private void checkActivityFailure() {
        if (this.activityException != null) {
            throw this.activityException;
        }
    }

    private void awaitServerExecution(WarpContext warpContext) {
        this.awaitResponse.fire((Object)new AwaitResponse());
        TestResult testResult = warpContext.getFirstNonSuccessfulResult();
        if (testResult == null) {
            return;
        }
        switch (testResult.getStatus()) {
            case FAILED: {
                this.propagateFailure(testResult);
                break;
            }
            case SKIPPED: {
                this.propagateSkip();
                break;
            }
            case PASSED: {
                throw new IllegalStateException("Passed test result should never be propagated as non-successful");
            }
        }
    }

    private void cleanup() {
        this.cleanEnrichment.fire((Object)new CleanEnrichment());
    }

    private void propagateFailure(TestResult testResult) {
        Throwable e = testResult.getThrowable();
        if (e instanceof AssertionError) {
            this.checkActivityFailure();
        }
        this.propagateException(e);
    }

    private void propagateException(Throwable e) {
        Rethrow.asUnchecked(e, ServerWarpExecutionException.class);
    }

    private void propagateSkip() {
        throw new ServerWarpExecutionException("execution was skipped");
    }
}

