/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.Activity;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.RequestObserver;
import org.jboss.arquillian.warp.client.execution.GroupExecutionSpecifier;
import org.jboss.arquillian.warp.client.execution.SingleInspectionSpecifier;
import org.jboss.arquillian.warp.client.execution.WarpExecutionBuilder;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.observer.ObserverBuilder;
import org.jboss.arquillian.warp.client.result.WarpResult;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.exception.ServerWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.event.ExecuteWarp;
import org.jboss.arquillian.warp.impl.client.execution.SecurityActions;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroupImpl;
import org.jboss.arquillian.warp.impl.client.execution.WarpRequestSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWarpRequestSpecifier
implements WarpRequestSpecifier {
    private int groupSequenceNumber = 0;
    private WarpContext warpContext;
    private Activity activity;
    private WarpGroup singleGroup;
    @Inject
    private Event<ExecuteWarp> executeWarp;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public WarpExecutionBuilder initiate(Activity activity) {
        this.ensureContextInitialized();
        this.activity = activity;
        return this;
    }

    public <T extends Inspection> T inspect(T inspection) {
        this.initializeSingleGroup();
        this.singleGroup.addInspections(inspection);
        WarpResult result = this.execute();
        return (T)result.getGroup(SingleInspectionSpecifier.GROUP_ID).getInspection();
    }

    public WarpResult inspectAll(Inspection ... inspections) {
        this.initializeSingleGroup();
        this.singleGroup.addInspections(inspections);
        return this.execute();
    }

    public WarpResult execute() {
        try {
            this.executeWarp.fire((Object)new ExecuteWarp(this.activity, this.warpContext));
            Exception executionException = this.warpContext.getFirstException();
            if (executionException != null) {
                this.propagateException(executionException);
            }
            WarpResult warpResult = this.warpContext.getResult();
            return warpResult;
        }
        finally {
            this.finalizeContext();
        }
    }

    public GroupExecutionSpecifier group() {
        return this.group(this.groupSequenceNumber++);
    }

    public GroupExecutionSpecifier group(Object identifier) {
        WarpGroupImpl group = new WarpGroupImpl(this, identifier);
        this.warpContext.addGroup(group);
        return group;
    }

    public SingleInspectionSpecifier observe(RequestObserver what) {
        this.initializeSingleGroup();
        this.singleGroup.observe(what);
        return this;
    }

    public SingleInspectionSpecifier observe(Class<? extends RequestObserver> what) {
        this.initializeSingleGroup();
        this.singleGroup.observe(this.createFilterInstance(what));
        return this;
    }

    public SingleInspectionSpecifier observe(ObserverBuilder<?, ?> filterBuilder) {
        this.initializeSingleGroup();
        this.singleGroup.observe(filterBuilder.build());
        return this;
    }

    private <T extends RequestObserver> T createFilterInstance(Class<T> filterClass) {
        return (T)((RequestObserver)SecurityActions.newInstance(filterClass.getName(), new Class[0], new Object[0], RequestFilter.class));
    }

    private void propagateException(Throwable e) {
        if (e instanceof AssertionError) {
            throw (AssertionError)((Object)e);
        }
        if (e instanceof ClientWarpExecutionException) {
            throw (ClientWarpExecutionException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ServerWarpExecutionException(e);
    }

    private void ensureContextInitialized() {
        if (this.warpContext == null) {
            this.warpContext = (WarpContext)((ServiceLoader)this.serviceLoader.get()).onlyOne(WarpContext.class);
            this.warpContext.initialize((ServiceLoader)this.serviceLoader.get());
        }
    }

    private void finalizeContext() {
        this.warpContext = null;
        this.singleGroup = null;
    }

    private void initializeSingleGroup() {
        if (this.singleGroup == null) {
            this.singleGroup = new WarpGroupImpl(this, SingleInspectionSpecifier.GROUP_ID);
            this.warpContext.addGroup(this.singleGroup);
        }
    }

    public static class ActivityException
    extends RuntimeException {
        private static final long serialVersionUID = 7267806785171391801L;

        public ActivityException(Throwable cause) {
            super(cause);
        }
    }
}

