/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.Collection;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.client.exception.MultipleGroupsPerRequestException;
import org.jboss.arquillian.warp.client.filter.Request;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseTransformationService;
import org.jboss.arquillian.warp.impl.client.event.DeenrichHttpResponse;
import org.jboss.arquillian.warp.impl.client.event.EnrichHttpRequest;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpRequest;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpResponse;
import org.jboss.arquillian.warp.impl.client.event.TransformHttpResponse;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.spi.WarpCommons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentObserver {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<EnrichHttpRequest> enrichHttpRequest;
    @Inject
    private Event<DeenrichHttpResponse> deenrichHttpResponse;

    public void tryEnrichRequest(@Observes FilterHttpRequest event) {
        Collection<RequestPayload> matchingPayloads;
        org.jboss.arquillian.warp.client.filter.http.HttpRequest request = event.getRequest();
        HttpRequestEnrichmentService enrichmentService = this.load(HttpRequestEnrichmentService.class);
        if (WarpCommons.debugMode()) {
            System.out.println("        (R) " + request.getUri() + " " + request.getMethod());
        }
        if ((matchingPayloads = enrichmentService.getMatchingPayloads(request)).isEmpty()) {
            this.warpContext().addUnmatchedRequest((Request)request);
        } else if (matchingPayloads.size() > 1) {
            this.warpContext().pushException((Exception)new MultipleGroupsPerRequestException(request.getUri()));
        } else {
            this.enrichHttpRequest.fire((Object)new EnrichHttpRequest(request, matchingPayloads.iterator().next(), enrichmentService));
        }
    }

    public void enrichRequest(@Observes EnrichHttpRequest event) {
        org.jboss.arquillian.warp.client.filter.http.HttpRequest request = event.getRequest();
        RequestPayload payload = event.getPayload();
        HttpRequestEnrichmentService enrichmentService = this.load(HttpRequestEnrichmentService.class);
        enrichmentService.enrichRequest(request, payload);
    }

    public void tryDeenrichResponse(@Observes FilterHttpResponse event) {
        HttpResponse response = event.getResponse();
        HttpRequest request = event.getRequest();
        HttpResponseDeenrichmentService service = this.load(HttpResponseDeenrichmentService.class);
        if (service.isEnriched(request, response)) {
            this.deenrichHttpResponse.fire((Object)new DeenrichHttpResponse(request, response));
        }
    }

    public void deenrichResponse(@Observes DeenrichHttpResponse event) {
        HttpResponse response = event.getResponse();
        HttpRequest request = event.getRequest();
        HttpResponseDeenrichmentService service = this.load(HttpResponseDeenrichmentService.class);
        service.deenrichResponse(request, response);
    }

    public void transformResponse(@Observes TransformHttpResponse event) {
        HttpResponse response = event.getResponse();
        HttpRequest request = event.getRequest();
        HttpResponseTransformationService service = this.load(HttpResponseTransformationService.class);
        response = service.transformResponse(request, response);
        event.setResponse(response);
    }

    private WarpContext warpContext() {
        return WarpContextStore.get();
    }

    private <T> T load(Class<T> serviceClass) {
        return (T)((ServiceLoader)this.serviceLoader.get()).onlyOne(serviceClass);
    }
}

