/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.warp.client.filter.http.HttpMethod;
import org.jboss.arquillian.warp.impl.utils.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestWrapper
implements org.jboss.arquillian.warp.client.filter.http.HttpRequest {
    private final HttpRequest request;
    private Map<String, List<String>> queryParameters;
    private Map<String, List<String>> httpDataAttributes;

    public HttpRequestWrapper(HttpRequest request) {
        this.request = request;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.request.getMethod().name());
    }

    public String getUri() {
        return this.request.getUri();
    }

    public URL getUrl() {
        return URLUtils.buildUrl(this.request.getUri(), new String[0]);
    }

    public String getHeader(String name) {
        return this.request.headers().get(name);
    }

    public List<String> getHeaders(String name) {
        return this.request.headers().getAll(name);
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.request.headers().entries();
    }

    public boolean containsHeader(String name) {
        return this.request.headers().contains(name);
    }

    public Set<String> getHeaderNames() {
        return this.request.headers().names();
    }

    public HttpRequest unwrap() {
        return this.request;
    }

    public String toString() {
        return String.format("%s %s", this.request.getMethod(), this.request.getUri());
    }

    public Map<String, List<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.request.getUri());
            this.queryParameters = queryStringDecoder.parameters();
        }
        return Collections.unmodifiableMap(this.queryParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getHttpDataAttributes() {
        if (!HttpMethod.POST.equals((Object)this.getMethod())) {
            throw new IllegalArgumentException("Cannot parse HttpData for requests other than POST");
        }
        try {
            if (this.httpDataAttributes == null) {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), this.request);
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                try {
                    for (InterfaceHttpData data : decoder.getBodyHttpDatas()) {
                        if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                        Attribute attribute = (Attribute)data;
                        LinkedList<String> list = (LinkedList<String>)map.get(attribute.getName());
                        if (list == null) {
                            list = new LinkedList<String>();
                            map.put(attribute.getName(), list);
                        }
                        list.add(attribute.getValue());
                    }
                }
                finally {
                    decoder.destroy();
                }
                this.httpDataAttributes = map;
            }
            return Collections.unmodifiableMap(this.httpDataAttributes);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse http request data", e);
        }
    }
}

