/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.filter.matcher;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpFilterBuilder;
import org.jboss.arquillian.warp.client.filter.http.HttpRequest;
import org.jboss.arquillian.warp.client.filter.matcher.HttpParameterMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.HttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.NotHttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.AbstractMatcherFilterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpParameterMatcherBuilder
extends AbstractMatcherFilterBuilder
implements HttpParameterMatcherBuilder<HttpFilterBuilder> {
    private Logger log = Logger.getLogger(DefaultHttpParameterMatcherBuilder.class.getName());

    public DefaultHttpParameterMatcherBuilder(HttpFilterChainBuilder<HttpFilterBuilder> filterChainBuilder) {
        super(filterChainBuilder);
    }

    public HttpFilterBuilder equal(final String parameterName, final String value) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                List parameters = DefaultHttpParameterMatcherBuilder.this.getParameterListOrNull(request, parameterName);
                return parameters != null && parameters.size() == 1 && parameters.contains(value);
            }

            public String toString() {
                return String.format("parameter.equal('%s', '%s')", parameterName, value);
            }
        });
    }

    public HttpFilterBuilder containsParameter(final String parameterName) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                List parameters = DefaultHttpParameterMatcherBuilder.this.getParameterListOrNull(request, parameterName);
                return parameters != null;
            }

            public String toString() {
                return String.format("containsParameter('%s')", parameterName);
            }
        });
    }

    public HttpFilterBuilder containsValue(final String parameterName, final String value) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                List parameters = DefaultHttpParameterMatcherBuilder.this.getParameterListOrNull(request, parameterName);
                return parameters != null && parameters.contains(value);
            }

            public String toString() {
                return String.format("containsValue('%s', '%s')", parameterName, value);
            }
        });
    }

    public HttpParameterMatcherBuilder not() {
        return new DefaultHttpParameterMatcherBuilder(new NotHttpFilterChainBuilder(this.getFilterChainBuilder()));
    }

    private List<String> getParameterListOrNull(HttpRequest request, String parameterName) {
        try {
            List<String> queryParameterList = this.getParameterListFromMapOrNull(request.getQueryParameters(), parameterName);
            if (queryParameterList != null) {
                return queryParameterList;
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "unable to parse query parameter list", e);
        }
        try {
            List<String> formDataList = this.getParameterListFromMapOrNull(request.getHttpDataAttributes(), parameterName);
            if (formDataList != null) {
                return formDataList;
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "unable to parse HTTP data attribute list", e);
        }
        return null;
    }

    private List<String> getParameterListFromMapOrNull(Map<String, List<String>> parameterMap, String parameterName) {
        List<String> queryParameterList;
        if (parameterMap != null && !parameterMap.isEmpty() && (queryParameterList = parameterMap.get(parameterName)) != null) {
            return queryParameterList;
        }
        return null;
    }
}

