/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.filter.matcher;

import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpFilterBuilder;
import org.jboss.arquillian.warp.client.filter.http.HttpRequest;
import org.jboss.arquillian.warp.client.filter.matcher.UriMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.HttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.NotHttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.AbstractMatcherFilterBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUriMatcherBuilder
extends AbstractMatcherFilterBuilder
implements UriMatcherBuilder<HttpFilterBuilder> {
    public DefaultUriMatcherBuilder(HttpFilterChainBuilder<HttpFilterBuilder> filterChainBuilder) {
        super(filterChainBuilder);
    }

    public HttpFilterBuilder equal(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.equals(value);
            }

            public String toString() {
                return String.format("equal('%s')", value);
            }
        });
    }

    public HttpFilterBuilder equalIgnoreCase(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.equalsIgnoreCase(value);
            }

            public String toString() {
                return String.format("equalIgnoreCase('%s')", value);
            }
        });
    }

    public HttpFilterBuilder startsWith(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.startsWith(value);
            }

            public String toString() {
                return String.format("startsWith('%s')", value);
            }
        });
    }

    public HttpFilterBuilder contains(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.contains(value);
            }

            public String toString() {
                return String.format("contains('%s')", value);
            }
        });
    }

    public HttpFilterBuilder endsWith(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.endsWith(value);
            }

            public String toString() {
                return String.format("endsWith('%s')", value);
            }
        });
    }

    public HttpFilterBuilder matches(final String value) {
        return this.addUriRequestFilter(new Matcher<String>(){

            @Override
            public boolean matches(String val) {
                return val.matches(value);
            }

            public String toString() {
                return String.format("matches('%s')", value);
            }
        });
    }

    private HttpFilterBuilder addUriRequestFilter(Matcher<String> matcher) {
        return this.addFilter(new UriMatcherRequestFilter(matcher));
    }

    public UriMatcherBuilder not() {
        return new DefaultUriMatcherBuilder(new NotHttpFilterChainBuilder(this.getFilterChainBuilder()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UriMatcherRequestFilter
    implements RequestFilter<HttpRequest> {
        private Matcher<String> matcher;

        UriMatcherRequestFilter(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        public boolean matches(HttpRequest request) {
            return this.matcher.matches(request.getUri());
        }

        public String toString() {
            return String.format("uri.%s", this.matcher);
        }
    }
}

