/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyURLToContextMapping {
    private ConcurrentHashMap<URL, OperationalContext> urlToContext = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, Set<URL>> testClassToUrls = new ConcurrentHashMap();

    public void register(URL proxyUrl, Class<?> testClass, OperationalContext context) {
        if (this.urlToContext.get(proxyUrl) != null) {
            throw new IllegalStateException("The OperatiocalContext was already set for URL: " + proxyUrl);
        }
        this.urlToContext.put(proxyUrl, context);
        Set<URL> urls = this.testClassToUrls.get(testClass);
        if (urls == null) {
            urls = new LinkedHashSet<URL>();
            this.testClassToUrls.put(testClass, urls);
        }
        urls.add(proxyUrl);
    }

    public OperationalContext get(URL proxyUrl) {
        OperationalContext operationalContext = this.urlToContext.get(proxyUrl);
        if (operationalContext == null) {
            throw new OperationalContextNotBoundException("The OperationalContext wasn't setup for this URL: " + proxyUrl);
        }
        return operationalContext;
    }

    public void unregister(Class<?> testClass) {
        Set<URL> urls = this.testClassToUrls.get(testClass);
        if (urls != null) {
            for (URL url : urls) {
                if (this.urlToContext.remove(url) != null) continue;
                throw new IllegalStateException("The OperationalContext wasn't setup for this URL: " + url);
            }
        }
    }

    public boolean isRegistered(URL proxyUrl) {
        return this.urlToContext.containsKey(proxyUrl);
    }

    public static class OperationalContextNotBoundException
    extends RuntimeException {
        private static final long serialVersionUID = 4855105259819295574L;

        public OperationalContextNotBoundException() {
        }

        public OperationalContextNotBoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public OperationalContextNotBoundException(String message) {
            super(message);
        }

        public OperationalContextNotBoundException(Throwable cause) {
            super(cause);
        }
    }
}

