/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.transformation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.client.separation.SeparateInvocator;
import org.jboss.arquillian.warp.impl.client.separation.SeparatedClassLoader;
import org.jboss.arquillian.warp.impl.client.transformation.InspectionTransformationException;
import org.jboss.arquillian.warp.impl.client.transformation.InstanceCreator;
import org.jboss.arquillian.warp.impl.client.transformation.TransformedInspection;
import org.jboss.arquillian.warp.impl.utils.ClassLoaderUtils;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class MigratedInspection {
    private TransformedInspection transformed;
    private MigrationResult migrated;

    public MigratedInspection(TransformedInspection transformed) throws InspectionTransformationException {
        this.transformed = transformed;
        this.migrated = this.migrate();
    }

    private MigrationResult migrate() throws InspectionTransformationException {
        byte[] oldClassFile = this.transformed.toBytecode();
        String oldClassName = this.transformed.getTransformedClass().getName();
        String newClassName = this.transformed.getOriginalClass().getName();
        Inspection serverInspection = this.transformed.getTransformedInspection();
        NamedAsset transformedAsset = this.transformed.toShrinkWrapAsset();
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            JavaArchive archive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).add(transformedAsset);
            ShrinkWrapClassLoader shrinkWrapClassLoader = new ShrinkWrapClassLoader(ClassLoaderUtils.getBootstrapClassLoader(), new Archive[]{archive});
            SeparatedClassLoader separatedClassLoader = new SeparatedClassLoader(new ClassLoader[]{shrinkWrapClassLoader, contextClassLoader});
            return ((Migration)SeparateInvocator.invoke(MigrationImpl.class, separatedClassLoader)).process(oldClassName, newClassName, oldClassFile, serverInspection);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot migrate transformed inspection back to original name", e);
        }
    }

    public byte[] toBytecode() {
        return this.migrated.bytecode;
    }

    public byte[] toSerializedForm() {
        return this.migrated.serializedMigratedInspection;
    }

    public static class MigrationResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] bytecode;
        public byte[] serializedMigratedInspection;
    }

    public static class MigrationImpl
    implements Migration {
        public MigrationResult process(String oldClassName, String newClassName, byte[] oldClassFile, Inspection transformedInspection) throws Exception {
            MigrationResult result = new MigrationResult();
            ClassPool pool = new ClassPool();
            CtClass clazz = pool.makeClassIfNew((InputStream)new ByteArrayInputStream(oldClassFile));
            clazz.replaceClassName(oldClassName, newClassName);
            Class migratedClass = clazz.toClass();
            result.bytecode = clazz.toBytecode();
            try {
                Class<?> oldClass = transformedInspection.getClass();
                Serializable migratedInspection = (Serializable)InstanceCreator.createInstance(migratedClass);
                for (Field newF : migratedClass.getDeclaredFields()) {
                    if (Modifier.isStatic(newF.getModifiers()) && Modifier.isFinal(newF.getModifiers())) continue;
                    Field oldF = oldClass.getDeclaredField(newF.getName());
                    oldF.setAccessible(true);
                    newF.setAccessible(true);
                    newF.set(migratedInspection, oldF.get(transformedInspection));
                }
                result.serializedMigratedInspection = SerializationUtils.serializeToBytes(migratedInspection);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to clone " + transformedInspection.getClass().getName() + " to migrated class " + migratedClass.getName(), e);
            }
            return result;
        }
    }

    public static interface Migration {
        public MigrationResult process(String var1, String var2, byte[] var3, Inspection var4) throws Exception;
    }
}

