/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.transformation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.UUID;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtNewConstructor;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.client.transformation.CtClassAsset;
import org.jboss.arquillian.warp.impl.client.transformation.InspectionTransformationException;
import org.jboss.arquillian.warp.impl.client.transformation.InstanceCreator;
import org.jboss.arquillian.warp.impl.client.transformation.NoSerialVersionUIDException;
import org.jboss.shrinkwrap.api.asset.NamedAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedInspection {
    private ClassPool classPool = ClassPool.getDefault();
    private Class<?> originalClass;
    private CtClass transformed;
    private Class<Inspection> transformedClass;
    private Inspection transformedInspection;

    public TransformedInspection(Inspection inspection) throws InspectionTransformationException {
        this(inspection.getClass(), "org.jboss.arquillian.warp.generated.A" + UUID.randomUUID().toString(), inspection);
    }

    private TransformedInspection(Class<?> originalClass, String newClassName, Inspection serverInspection) throws InspectionTransformationException {
        this.originalClass = originalClass;
        this.transformed = this.transform(newClassName);
        this.transformedClass = this.toClass();
        this.transformedInspection = this.cloneToNew(serverInspection);
    }

    private CtClass transform(String newClassName) throws InspectionTransformationException {
        try {
            CtClass output = this.classPool.getAndRename(this.originalClass.getName(), newClassName);
            output.getClassFile2().getAttributes().remove(output.getClassFile2().getAttribute("EnclosingMethod"));
            output.getClassFile2().getAttributes().remove(output.getClassFile2().getAttribute("InnerClasses"));
            output.setModifiers(1);
            for (CtField field : output.getDeclaredFields()) {
                if (!field.getName().equals("this$0")) continue;
                output.removeField(field);
            }
            CtField field = output.getField("serialVersionUID");
            if (field.getDeclaringClass() != output) {
                throw new NoSerialVersionUIDException("serialVersionUID for class " + this.originalClass.getName() + " is not set; please set serialVersionUID to allow Warp work correctly");
            }
            for (CtConstructor constructor : output.getConstructors()) {
                output.removeConstructor(constructor);
            }
            output.addConstructor(CtNewConstructor.defaultConstructor((CtClass)output));
            return output;
        }
        catch (Exception e) {
            throw new InspectionTransformationException("Unable to transform inspection " + this.originalClass.getName() + ":\n" + e.getMessage(), e);
        }
    }

    private Inspection cloneToNew(Inspection obj) throws InspectionTransformationException {
        try {
            Class<?> oldClass = obj.getClass();
            Inspection newObj = (Inspection)InstanceCreator.createInstance(this.transformedClass);
            Class<Inspection> newClass = this.transformedClass;
            while (newClass != Object.class) {
                for (Field newF : newClass.getDeclaredFields()) {
                    if (Modifier.isStatic(newF.getModifiers()) && Modifier.isFinal(newF.getModifiers())) continue;
                    Field oldF = oldClass.getDeclaredField(newF.getName());
                    oldF.setAccessible(true);
                    newF.setAccessible(true);
                    newF.set(newObj, oldF.get(obj));
                }
                newClass = newClass.getSuperclass();
                oldClass = oldClass.getSuperclass();
            }
            return newObj;
        }
        catch (Exception e) {
            throw new InspectionTransformationException("Unable to clone " + obj.getClass().getName() + " to " + this.transformed.getName(), e);
        }
    }

    public byte[] toBytecode() throws InspectionTransformationException {
        try {
            return this.transformed.toBytecode();
        }
        catch (Exception e) {
            throw new InspectionTransformationException("Unable to convert " + this.transformed.getName() + " to bytecode", e);
        }
    }

    public NamedAsset toShrinkWrapAsset() {
        return new CtClassAsset(this.transformed);
    }

    public Class<?> getTransformedClass() {
        return this.transformedClass;
    }

    public Inspection getTransformedInspection() {
        return this.transformedInspection;
    }

    private Class<Inspection> toClass() throws InspectionTransformationException {
        try {
            return this.transformed.toClass();
        }
        catch (Exception e) {
            throw new InspectionTransformationException("Unable to convert " + this.transformed.getName() + " to class", e);
        }
    }

    public Class<?> getOriginalClass() {
        return this.originalClass;
    }
}

