/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.commandBus;

import org.jboss.arquillian.warp.impl.server.commandBus.CommandBusOnServer;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandPayload;
import org.jboss.arquillian.warp.impl.shared.command.CommandService;
import org.jboss.arquillian.warp.impl.utils.Rethrow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServiceOnServer
implements CommandService {
    private static long TIMEOUT = 30000L;

    @Override
    public <T extends Command> T execute(T operation) {
        String currentId = CommandBusOnServer.getCurrentCall();
        CommandPayload payload = new CommandPayload(operation);
        CommandBusOnServer.getEvents().put(currentId, payload);
        long timeoutTime = System.currentTimeMillis() + TIMEOUT;
        while (timeoutTime > System.currentTimeMillis()) {
            CommandPayload responsePayload = CommandBusOnServer.getEvents().get(currentId);
            if (responsePayload != null && responsePayload.isExecuted()) {
                if (responsePayload.getThrowable() != null) {
                    Rethrow.asUnchecked(responsePayload.getThrowable());
                }
                return (T)responsePayload.getCommand();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No command response within timeout of " + TIMEOUT + " ms.");
    }
}

