/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.inspection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;

public class PayloadRegistry {
    private Map<Long, RequestPayload> requestPayloads = new ConcurrentHashMap<Long, RequestPayload>();
    private Map<Long, ResponsePayload> responsePayloads = new ConcurrentHashMap<Long, ResponsePayload>();

    public void registerRequestPayload(RequestPayload requestPayload) {
        long serialId = requestPayload.getSerialId();
        if (this.requestPayloads.put(serialId, requestPayload) != null) {
            throw new IllegalStateException("The request payload with serialId " + serialId + " was already registered");
        }
    }

    public RequestPayload retrieveRequestPayload(long serialId) {
        RequestPayload payload = this.requestPayloads.remove(serialId);
        if (payload == null) {
            throw new IllegalStateException("The request payload with serialId" + serialId + " was never registered");
        }
        return payload;
    }

    public void registerResponsePayload(ResponsePayload responsePayload) {
        long serialId = responsePayload.getSerialId();
        if (this.responsePayloads.put(serialId, responsePayload) != null) {
            throw new IllegalStateException("The response payload with serialId " + serialId + " was already registered");
        }
    }

    public ResponsePayload retrieveResponsePayload(long serialId) {
        ResponsePayload payload = this.responsePayloads.remove(serialId);
        if (payload == null) {
            throw new ResponsePayloadWasNeverRegistered("The response payload with serialId " + serialId + " was never registered");
        }
        return payload;
    }

    public static class ResponsePayloadWasNeverRegistered
    extends RuntimeException {
        private static final long serialVersionUID = 6156176090793881709L;

        public ResponsePayloadWasNeverRegistered() {
        }

        public ResponsePayloadWasNeverRegistered(String message, Throwable cause) {
            super(message, cause);
        }

        public ResponsePayloadWasNeverRegistered(String message) {
            super(message);
        }

        public ResponsePayloadWasNeverRegistered(Throwable cause) {
            super(cause);
        }
    }
}

