/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.request;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.context.RequestContext;
import org.jboss.arquillian.warp.spi.context.RequestScoped;
import org.jboss.arquillian.warp.spi.event.AfterRequest;
import org.jboss.arquillian.warp.spi.event.BeforeRequest;
import org.jboss.arquillian.warp.spi.servlet.event.ProcessHttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContextHandler {
    @Inject
    private Instance<RequestContext> requestContextInstance;
    @Inject
    @RequestScoped
    private InstanceProducer<ServletRequest> servletRequest;
    @Inject
    @RequestScoped
    private InstanceProducer<ServletResponse> servletResponse;
    @Inject
    @RequestScoped
    private InstanceProducer<HttpServletRequest> httpServletRequest;
    @Inject
    @RequestScoped
    private InstanceProducer<HttpServletResponse> httpServletResponse;
    @Inject
    @RequestScoped
    private InstanceProducer<FilterChain> filterChain;
    @Inject
    private Event<BeforeRequest> beforeRequest;
    @Inject
    private Event<AfterRequest> afterRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestContext(@Observes(precedence=100) EventContext<ProcessHttpRequest> context) {
        RequestContext testContext = (RequestContext)this.requestContextInstance.get();
        String requestId = String.valueOf(((ProcessHttpRequest)context.getEvent()).getRequest().getAttribute(WarpCommons.WARP_REQUEST_ID));
        try {
            testContext.activate((Object)requestId);
            this.servletRequest.set((Object)((ProcessHttpRequest)context.getEvent()).getRequest());
            this.servletResponse.set((Object)((ProcessHttpRequest)context.getEvent()).getResponse());
            this.httpServletRequest.set((Object)((ProcessHttpRequest)context.getEvent()).getRequest());
            this.httpServletResponse.set((Object)((ProcessHttpRequest)context.getEvent()).getResponse());
            this.filterChain.set((Object)((ProcessHttpRequest)context.getEvent()).getFilterChain());
            this.beforeRequest.fire((Object)new BeforeRequest((ServletRequest)((ProcessHttpRequest)context.getEvent()).getRequest(), (ServletResponse)((ProcessHttpRequest)context.getEvent()).getResponse()));
            context.proceed();
        }
        finally {
            try {
                this.afterRequest.fire((Object)new AfterRequest((ServletRequest)((ProcessHttpRequest)context.getEvent()).getRequest(), (ServletResponse)((ProcessHttpRequest)context.getEvent()).getResponse()));
            }
            finally {
                testContext.deactivate();
                testContext.destroy((Object)requestId);
            }
        }
    }
}

