/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.shared;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.client.transformation.MigratedInspection;
import org.jboss.arquillian.warp.impl.client.transformation.TransformedInspection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPayload
implements Externalizable {
    private static final long serialVersionUID = -5537112559937896153L;
    public static final long FAILURE_SERIAL_ID = -1L;
    private List<Inspection> inspections;
    private long serialId;
    private static final DynamicClassLoader cl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
    private static final ConcurrentHashMap<String, Class<?>> loadedClasses = new ConcurrentHashMap();

    public RequestPayload() {
    }

    public RequestPayload(Inspection ... inspections) {
        this(Arrays.asList(inspections));
    }

    public RequestPayload(List<Inspection> inspections) {
        this.inspections = inspections;
        this.serialId = UUID.randomUUID().getMostSignificantBits();
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public long getSerialId() {
        return this.serialId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serialId = in.readLong();
        int size = in.read();
        this.inspections = new ArrayList<Inspection>(size);
        for (int i = 0; i < size; ++i) {
            boolean anonymous = in.readBoolean();
            if (anonymous) {
                String className = (String)in.readObject();
                byte[] classFile = (byte[])in.readObject();
                byte[] obj = (byte[])in.readObject();
                Inspection inspection = (Inspection)this.loadObject(className, classFile, obj);
                this.inspections.add(inspection);
                continue;
            }
            this.inspections.add((Inspection)in.readObject());
        }
    }

    private <T> T loadObject(String className, byte[] classFile, byte[] obj) throws IOException, ClassNotFoundException {
        final Class<?> clazz = this.loadClass(className, classFile);
        ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(obj)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (desc.getName().equals(clazz.getName())) {
                    return clazz;
                }
                return super.resolveClass(desc);
            }
        };
        return (T)input.readObject();
    }

    private Class<?> loadClass(String className, byte[] classFile) {
        if (loadedClasses.containsKey(className)) {
            return loadedClasses.get(className);
        }
        Class<?> clazz = cl.load(classFile);
        loadedClasses.put(className, clazz);
        return clazz;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.serialId);
        out.write(this.inspections.size());
        for (Inspection inspection : this.inspections) {
            if (this.shouldBeTransformed(inspection)) {
                try {
                    out.writeBoolean(true);
                    TransformedInspection transformed = new TransformedInspection(inspection);
                    MigratedInspection migrated = new MigratedInspection(transformed);
                    out.writeObject(transformed.getOriginalClass().getName());
                    out.writeObject(migrated.toBytecode());
                    out.writeObject(migrated.toSerializedForm());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not transform and replicate class " + this.inspections.getClass() + ":\n" + e.getMessage(), e);
                }
            }
            out.writeBoolean(false);
            out.writeObject(inspection);
        }
    }

    private boolean shouldBeTransformed(Inspection inspection) {
        return inspection.getClass().isAnonymousClass() || inspection.getClass().isMemberClass();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.serialId ^ this.serialId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestPayload other = (RequestPayload)obj;
        return this.serialId == other.serialId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicClassLoader
    extends ClassLoader {
        public DynamicClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> load(byte[] classFile) {
            return this.defineClass(null, classFile, 0, classFile.length);
        }
    }
}

