/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Platform {
    WINDOWS(new String[]{""}){}
    ,
    XP(new String[]{"Windows Server 2003", "xp", "windows", "winnt"}){

        public Platform family() {
            return WINDOWS;
        }
    }
    ,
    VISTA(new String[]{"windows vista", "Windows Server 2008", "windows 7", "win7"}){

        public Platform family() {
            return WINDOWS;
        }
    }
    ,
    WIN8(new String[]{"Windows Server 2012", "windows 8", "win8"}){

        public Platform family() {
            return WINDOWS;
        }
    }
    ,
    WIN8_1(new String[]{"windows 8.1", "win8.1"}){

        public Platform family() {
            return WINDOWS;
        }
    }
    ,
    MAC(new String[]{"mac", "darwin", "os x"}){}
    ,
    SNOW_LEOPARD(new String[]{"snow leopard", "os x 10.6"}){

        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.6";
        }
    }
    ,
    MOUNTAIN_LION(new String[]{"mountain lion", "os x 10.8"}){

        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.8";
        }
    }
    ,
    MAVERICKS(new String[]{"mavericks", "os x 10.9"}){

        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.9";
        }
    }
    ,
    YOSEMITE(new String[]{"yosemite", "os x 10.10"}){

        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.10";
        }
    }
    ,
    UNIX(new String[]{"solaris", "bsd"}){}
    ,
    LINUX(new String[]{"linux"}){

        public Platform family() {
            return UNIX;
        }
    }
    ,
    ANDROID(new String[]{"android", "dalvik"}){

        public String getLineEnding() {
            return "\n";
        }

        public Platform family() {
            return LINUX;
        }
    }
    ,
    ANY(new String[]{""}){

        public boolean is(Platform compareWith) {
            return this == compareWith;
        }
    };

    private final String[] partOfOsName;
    private final int minorVersion;
    private final int majorVersion;

    private Platform(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
        String version = System.getProperty("os.version", "0.0.0");
        int major = 0;
        int min = 0;
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+).*");
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            try {
                major = Integer.parseInt(matcher.group(1));
                min = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.majorVersion = major;
        this.minorVersion = min;
    }

    public String[] getPartOfOsName() {
        return this.partOfOsName;
    }

    public static Platform getCurrent() {
        return Platform.extractFromSysProperty(System.getProperty("os.name"));
    }

    public static Platform extractFromSysProperty(String osName) {
        return Platform.extractFromSysProperty(osName, System.getProperty("os.version"));
    }

    public static Platform extractFromSysProperty(String osName, String osVersion) {
        osName = osName.toLowerCase();
        if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
            return ANDROID;
        }
        if (osVersion.equals("6.2") && osName.startsWith("windows nt")) {
            return WIN8;
        }
        if (osVersion.equals("6.3") && osName.startsWith("windows nt")) {
            return WIN8_1;
        }
        Platform mostLikely = UNIX;
        String previousMatch = null;
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if ("".equals(matcher)) continue;
                if (os.isExactMatch(osName, matcher = matcher.toLowerCase())) {
                    return os;
                }
                if (!os.isCurrentPlatform(osName, matcher) || !Platform.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        return mostLikely;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        return previous == null || matcher.length() >= previous.length();
    }

    public boolean is(Platform compareWith) {
        return this == compareWith || this.family().is(compareWith);
    }

    public Platform family() {
        return ANY;
    }

    private boolean isCurrentPlatform(String osName, String matchAgainst) {
        return osName.contains(matchAgainst);
    }

    private boolean isExactMatch(String osName, String matchAgainst) {
        return matchAgainst.equals(osName);
    }
}

