/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.extension.spring.container;

import javax.servlet.ServletRequest;
import org.jboss.arquillian.warp.extension.spring.container.SpringMvcResultImpl;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public final class SpringMvcResultBuilder {
    private final ServletRequest servletRequest;
    private final SpringMvcResultImpl springMvcResult;

    private SpringMvcResultBuilder(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        this.springMvcResult = this.getRequestMvcResult();
    }

    public static SpringMvcResultBuilder buildMvc(ServletRequest servletRequest) {
        return new SpringMvcResultBuilder(servletRequest);
    }

    public SpringMvcResultBuilder setModelAndView(ModelAndView modelAndView) {
        this.springMvcResult.setModelAndView(modelAndView);
        return this;
    }

    public SpringMvcResultBuilder setHandler(Object handler) {
        this.springMvcResult.setHandler(handler);
        return this;
    }

    public SpringMvcResultBuilder setInterceptors(HandlerInterceptor[] interceptors) {
        this.springMvcResult.setInterceptors(interceptors);
        return this;
    }

    public SpringMvcResultBuilder setException(Exception exception) {
        this.springMvcResult.setException(exception);
        return this;
    }

    private SpringMvcResultImpl getRequestMvcResult() {
        SpringMvcResultImpl requestResult = (SpringMvcResultImpl)this.servletRequest.getAttribute("org.jboss.arquillian.warp.extension.spring.SPRING_MVC_RESULT");
        if (requestResult == null) {
            requestResult = new SpringMvcResultImpl();
            this.servletRequest.setAttribute("org.jboss.arquillian.warp.extension.spring.SPRING_MVC_RESULT", (Object)requestResult);
        }
        return requestResult;
    }
}

