/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.browser.impl;

import org.arquillian.extension.recorder.DefaultFileNameBuilder;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.When;
import org.arquillian.extension.recorder.screenshooter.ScreenshooterConfiguration;
import org.arquillian.extension.recorder.screenshooter.browser.configuration.BrowserScreenshooterConfiguration;
import org.arquillian.extension.recorder.screenshooter.browser.impl.InterceptorRegistry;
import org.arquillian.extension.recorder.screenshooter.browser.impl.ResourceIdentifierFactory;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotAndReportService;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotBeforeTestInterceptor;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotOnEveryActionInterceptor;
import org.arquillian.extension.recorder.screenshooter.event.TakeScreenshot;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.event.suite.After;

public class ScreenshotTaker {
    @Inject
    private Instance<ScreenshooterConfiguration> configuration;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<InterceptorRegistry> interceptorRegistry;

    public void onTakeScreenshot(@Observes TakeScreenshot event) {
        if (event.getWhen() == When.BEFORE && ((ScreenshooterConfiguration)this.configuration.get()).getTakeBeforeTest()) {
            TakeScreenshotBeforeTestInterceptor beforeInterceptor = new TakeScreenshotBeforeTestInterceptor(event, this.getTakeAndReportService(), (InterceptorRegistry)this.interceptorRegistry.get());
            ((InterceptorRegistry)this.interceptorRegistry.get()).register(beforeInterceptor);
            boolean willTakeScreenshot = false;
            if (event.getAnnotation() != null && event.getAnnotation().takeOnEveryAction() || event.getAnnotation() == null && ((BrowserScreenshooterConfiguration)((Object)this.configuration.get())).getTakeOnEveryAction()) {
                willTakeScreenshot = true;
            }
            if (willTakeScreenshot) {
                TakeScreenshotOnEveryActionInterceptor onEveryActionInterceptor = new TakeScreenshotOnEveryActionInterceptor(event, this.getTakeAndReportService(), (InterceptorRegistry)this.interceptorRegistry.get());
                ((InterceptorRegistry)this.interceptorRegistry.get()).register(onEveryActionInterceptor);
            }
        } else {
            DefaultFileNameBuilder nameBuilder = new DefaultFileNameBuilder();
            String screenshotName = nameBuilder.withMetaData((ResourceMetaData)event.getMetaData()).withStage(event.getWhen()).withResourceIdentifier(ResourceIdentifierFactory.getResoruceIdentifier((ResourceMetaData)event.getMetaData(), event.getWhen())).build();
            event.setFileName(screenshotName);
            this.getTakeAndReportService().takeScreenshotAndReport(event);
        }
    }

    public void unregisterInterceptors(@Observes(precedence=-2147483648) After event) {
        InterceptorRegistry registry = (InterceptorRegistry)this.interceptorRegistry.get();
        registry.unregisterAll();
    }

    private TakeScreenshotAndReportService getTakeAndReportService() {
        return (TakeScreenshotAndReportService)((ServiceLoader)this.serviceLoader.get()).onlyOne(TakeScreenshotAndReportService.class);
    }
}

