/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.browser.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.arquillian.extension.recorder.DefaultFileNameBuilder;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.When;
import org.arquillian.extension.recorder.screenshooter.browser.impl.AbstractTakeScreenshotInterceptor;
import org.arquillian.extension.recorder.screenshooter.browser.impl.InterceptorRegistry;
import org.arquillian.extension.recorder.screenshooter.browser.impl.ResourceIdentifierFactory;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotAndReportService;
import org.arquillian.extension.recorder.screenshooter.event.TakeScreenshot;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.WebDriver;

public class TakeScreenshotOnEveryActionInterceptor
extends AbstractTakeScreenshotInterceptor {
    private int counter = 0;
    private static final List<Method> WHITE_LIST_WEB_DRIVER_METHODS = Arrays.asList(WebDriver.class.getMethods());

    public TakeScreenshotOnEveryActionInterceptor(TakeScreenshot takeScreenshotEvent, TakeScreenshotAndReportService takeScreenAndReportservice, InterceptorRegistry interceptorRegistryService) {
        super(takeScreenshotEvent, takeScreenAndReportservice, interceptorRegistryService);
    }

    public Object intercept(InvocationContext context) throws Throwable {
        List<Interceptor> previouslyRegistered = this.interceptorRegistryService.unregisterAll();
        Object result = context.invoke();
        if (previouslyRegistered.isEmpty()) {
            return result;
        }
        Method interceptedMethod = context.getMethod();
        if (this.isInterceptedMethodAllowed(interceptedMethod)) {
            When when = When.ON_EVERY_ACTION;
            this.takeScreenshotEvent.getMetaData().setOptionalDescription(interceptedMethod.getName() + Integer.toString(this.counter++));
            DefaultFileNameBuilder nameBuilder = new DefaultFileNameBuilder();
            String screenshotName = nameBuilder.withMetaData((ResourceMetaData)this.takeScreenshotEvent.getMetaData()).withStage(when).withResourceIdentifier(ResourceIdentifierFactory.getResoruceIdentifier((ResourceMetaData)this.takeScreenshotEvent.getMetaData(), when)).build();
            this.takeScreenshotEvent.setFileName(screenshotName);
            this.takeScreenshotEvent.setWhen(screenshotName.contains("before") ? When.BEFORE : When.ON_EVERY_ACTION);
            this.takeScreenshotAndReport();
        }
        this.interceptorRegistryService.registerAll(previouslyRegistered);
        return result;
    }

    private boolean isInterceptedMethodAllowed(Method interceptedMethod) {
        boolean result = false;
        for (Method whiteListMethod : WHITE_LIST_WEB_DRIVER_METHODS) {
            if (!TakeScreenshotOnEveryActionInterceptor.methodsEqual(interceptedMethod, whiteListMethod)) continue;
            result = true;
        }
        return result;
    }

    private static boolean methodsEqual(Method first, Method second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (first.getParameterTypes().length != second.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < first.getParameterTypes().length; ++i) {
            if (first.getParameterTypes()[i].equals(second.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public int getPrecedence() {
        return 100;
    }
}

