/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.browser.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.arquillian.extension.recorder.RecorderFileUtils;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.ResourceType;
import org.arquillian.extension.recorder.screenshooter.Screenshooter;
import org.arquillian.extension.recorder.screenshooter.ScreenshooterConfiguration;
import org.arquillian.extension.recorder.screenshooter.Screenshot;
import org.arquillian.extension.recorder.screenshooter.ScreenshotMetaData;
import org.arquillian.extension.recorder.screenshooter.ScreenshotType;
import org.arquillian.extension.recorder.screenshooter.browser.impl.BrowserScreenshot;
import org.arquillian.extension.recorder.screenshooter.browser.impl.ResourceIdentifierFactory;
import org.arquillian.recorder.reporter.impl.TakenResourceRegister;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;

public class BrowserScreenshooter
implements Screenshooter {
    private File screenshotTargetDir = null;
    private ScreenshotType screenshotType = null;
    private ScreenshooterConfiguration configuration;
    private TakenResourceRegister takenResourceRegister;
    private String message;
    private Logger log = Logger.getLogger(BrowserScreenshooter.class.getName());

    public BrowserScreenshooter(TakenResourceRegister takenResourceRegister) {
        Validate.notNull((Object)takenResourceRegister, (String)"Taken resource register can not be a null object!");
        this.takenResourceRegister = takenResourceRegister;
    }

    public Screenshot takeScreenshot() {
        return this.takeScreenshot(this.screenshotType);
    }

    public Screenshot takeScreenshot(ScreenshotType type) {
        Validate.notNull((Object)type, (String)"Screenshot type is a null object!");
        ScreenshotMetaData metaData = new ScreenshotMetaData();
        metaData.setResourceType((ResourceType)type);
        return this.takeScreenshot(new File(ResourceIdentifierFactory.getResoruceIdentifier((ResourceMetaData)metaData, null).getIdentifier((ResourceType)type)), type);
    }

    public Screenshot takeScreenshot(String fileName) {
        Validate.notNullOrEmpty((String)fileName, (String)"File name is a null object or an empty string!");
        return this.takeScreenshot(new File(fileName));
    }

    public Screenshot takeScreenshot(File file) {
        Validate.notNull((Object)file, (String)"File is a null object!");
        return this.takeScreenshot(file, this.screenshotType);
    }

    private File getJustTargetDir(File screenshotToTake) {
        return new File(screenshotToTake.getPath().substring(0, screenshotToTake.getPath().lastIndexOf(System.getProperty("file.separator"))));
    }

    public Screenshot takeScreenshot(String fileName, ScreenshotType type) {
        Validate.notNullOrEmpty((String)fileName, (String)"File name is a null object or an empty string!");
        Validate.notNull((Object)type, (String)"Type of screenshot is a null object!");
        return this.takeScreenshot(new File(fileName), type);
    }

    public Screenshot takeScreenshot(File screenshotToTake, ScreenshotType type) {
        WebDriver browser = this.getTakingScreenshotsBrowser(screenshotToTake);
        screenshotToTake = new File(this.screenshotTargetDir, screenshotToTake.getPath());
        File targetDir = this.getJustTargetDir(screenshotToTake);
        RecorderFileUtils.createDirectory((File)targetDir);
        if (browser == null) {
            return null;
        }
        try {
            FileUtils.copyFile((File)((File)((TakesScreenshot)browser).getScreenshotAs(OutputType.FILE)), (File)screenshotToTake);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during saving the screenshot!", e);
        }
        BrowserScreenshot screenshoot = new BrowserScreenshot();
        screenshoot.setResource(screenshotToTake);
        screenshoot.setResourceType((ResourceType)this.screenshotType);
        screenshoot.setMessage(this.message);
        try {
            BufferedImage bimg = ImageIO.read(screenshotToTake);
            screenshoot.setWidth(bimg.getWidth());
            screenshoot.setHeight(bimg.getHeight());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get width and height of taken image located at " + screenshoot.getResource().getAbsolutePath());
        }
        this.takenResourceRegister.addTaken((Screenshot)screenshoot);
        return screenshoot;
    }

    private WebDriver getTakingScreenshotsBrowser(File screenshotToTake) {
        WebDriver result = null;
        try {
            GrapheneContext context = GrapheneContext.getContextFor(Default.class);
            result = (WebDriver)((GrapheneProxyInstance)context.getWebDriver(new Class[]{TakesScreenshot.class})).unwrap();
        }
        catch (IllegalStateException ex) {
            this.log.info("The screenshot " + screenshotToTake.getPath() + " hasn't been taken." + " The reason: " + ex.getMessage());
            return null;
        }
        if (result instanceof ReusableRemoteWebDriver) {
            result = new Augmenter().augment(result);
        }
        return result;
    }

    public Screenshooter setScreenshotTargetDir(String screenshotTargetDir) {
        Validate.notNullOrEmpty((String)screenshotTargetDir, (String)"Screenshot target directory can not be a null object or an empty string");
        return this.setScreenshotTargetDir(new File(screenshotTargetDir));
    }

    public Screenshooter setScreenshotTargetDir(File screenshotTargetDir) {
        Validate.notNull((Object)screenshotTargetDir, (String)"File is a null object!");
        RecorderFileUtils.createDirectory((File)screenshotTargetDir);
        this.screenshotTargetDir = screenshotTargetDir;
        return this;
    }

    public Screenshooter setScreenshotType(ScreenshotType screenshotType) {
        Validate.notNull((Object)screenshotType, (String)"Screenshot type is a null object!");
        this.screenshotType = screenshotType;
        return this;
    }

    public void init(ScreenshooterConfiguration configuration) {
        if (this.configuration == null && configuration != null) {
            this.configuration = configuration;
            this.setScreenshotTargetDir(configuration.getRootDir());
            this.setScreenshotType(ScreenshotType.valueOf((String)this.configuration.getScreenshotType()));
        }
    }

    public ScreenshotType getScreenshotType() {
        return this.screenshotType;
    }

    public Screenshooter setMessage(String message) {
        this.message = message;
        return this;
    }
}

