/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.browser.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.extension.recorder.DefaultFileNameBuilder;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.When;
import org.arquillian.extension.recorder.screenshooter.browser.impl.AbstractTakeScreenshotInterceptor;
import org.arquillian.extension.recorder.screenshooter.browser.impl.InterceptorRegistry;
import org.arquillian.extension.recorder.screenshooter.browser.impl.ResourceIdentifierFactory;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotAndReportService;
import org.arquillian.extension.recorder.screenshooter.event.TakeScreenshot;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TakeScreenshotOnEveryActionInterceptor
extends AbstractTakeScreenshotInterceptor {
    private int counter = 0;
    private static final List<Method> WHITE_LIST_WEB_DRIVER_METHODS = TakeScreenshotOnEveryActionInterceptor.getWhiteListWebDriverMethods();

    public TakeScreenshotOnEveryActionInterceptor(TakeScreenshot takeScreenshot, TakeScreenshotAndReportService takeScreenAndReportservice, InterceptorRegistry interceptorRegistryService) {
        super(takeScreenshot, takeScreenAndReportservice, interceptorRegistryService);
    }

    public Object intercept(InvocationContext context) throws Throwable {
        List<Interceptor> previouslyRegistered = this.interceptorRegistryService.unregisterAll();
        Object result = context.invoke();
        if (previouslyRegistered.isEmpty()) {
            return result;
        }
        Method interceptedMethod = context.getMethod();
        if (this.isInterceptedMethodAllowed(interceptedMethod)) {
            When when = When.ON_EVERY_ACTION;
            this.takeScreenshot.getMetaData().setOptionalDescription(interceptedMethod.getName() + Integer.toString(this.counter++));
            DefaultFileNameBuilder nameBuilder = new DefaultFileNameBuilder();
            String screenshotName = nameBuilder.withMetaData((ResourceMetaData)this.takeScreenshot.getMetaData()).withStage(when).withResourceIdentifier(ResourceIdentifierFactory.getResoruceIdentifier((ResourceMetaData)this.takeScreenshot.getMetaData(), when)).build();
            this.takeScreenshot.setFileName(screenshotName);
            this.takeScreenshot.setWhen(When.ON_EVERY_ACTION);
            this.takeScreenshotAndReport();
        }
        this.interceptorRegistryService.registerAll(previouslyRegistered);
        return result;
    }

    private boolean isInterceptedMethodAllowed(Method interceptedMethod) {
        boolean result = false;
        for (Method whiteListMethod : WHITE_LIST_WEB_DRIVER_METHODS) {
            if (!TakeScreenshotOnEveryActionInterceptor.methodsEqual(interceptedMethod, whiteListMethod)) continue;
            result = true;
        }
        return result;
    }

    private static List<Method> getWhiteListWebDriverMethods() {
        ArrayList methods = Lists.newArrayList((Object[])WebDriver.class.getMethods());
        try {
            methods.remove(WebDriver.class.getMethod("close", new Class[0]));
            methods.remove(WebDriver.class.getMethod("quit", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return methods;
    }

    private static boolean methodsEqual(Method first, Method second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (first.getParameterTypes().length != second.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < first.getParameterTypes().length; ++i) {
            if (first.getParameterTypes()[i].equals(second.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public int getPrecedence() {
        return 100;
    }
}

