/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.drone.configuration;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.ajocado.browser.Browser;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;

public class ArquillianGrapheneConfiguration
implements GrapheneConfiguration,
AjocadoConfiguration,
DroneConfiguration<ArquillianGrapheneConfiguration> {
    private static final long serialVersionUID = 5560505506114056625L;
    public static final String CONFIGURATION_NAME = "graphene";
    private URL contextRoot;
    private String contextPath = "";
    private String browser = "*firefox";
    private File resourcesDirectory = new File("target/test-classes");
    private File buildDirectory = new File("target/");
    private String seleniumHost = "localhost";
    private int seleniumPort = 14444;
    private boolean seleniumMaximize = false;
    private boolean seleniumDebug = false;
    private boolean seleniumNetworkTrafficEnabled = false;
    private String startParameters;
    private int seleniumSpeed = 0;
    private long seleniumTimeoutDefault = 30000L;
    private long seleniumTimeoutGui = 5000L;
    private long seleniumTimeoutAjax = 15000L;
    private long seleniumTimeoutModel = 30000L;

    public ArquillianGrapheneConfiguration() {
        this.initContextRoot();
    }

    public ArquillianGrapheneConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        return (ArquillianGrapheneConfiguration)ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, qualifier);
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    public URL getContextRoot() {
        try {
            if (this.contextRoot != null && !this.contextRoot.toString().endsWith("/")) {
                this.contextRoot = new URL(this.contextRoot.toString() + "/");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert contextRoot from configuration to URL", e);
        }
        return this.contextRoot;
    }

    public void setContextRoot(URL contextRoot) {
        this.contextRoot = contextRoot;
    }

    public URL getContextPath() {
        if (this.contextPath.startsWith("/")) {
            this.contextPath = this.contextPath.substring(1);
        }
        if (!this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        try {
            return new URL(this.getContextRoot(), this.contextPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert context path from configuration to URL", e);
        }
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Browser getBrowser() {
        return new Browser(this.browser);
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public File getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public void setResourcesDirectory(File resourcesDirectory) {
        this.resourcesDirectory = resourcesDirectory;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public String getSeleniumHost() {
        return this.seleniumHost;
    }

    public void setSeleniumHost(String seleniumHost) {
        this.seleniumHost = seleniumHost;
    }

    public int getSeleniumPort() {
        return this.seleniumPort;
    }

    public void setSeleniumPort(int seleniumPort) {
        this.seleniumPort = seleniumPort;
    }

    public boolean isSeleniumMaximize() {
        return this.seleniumMaximize;
    }

    public void setSeleniumMaximize(boolean seleniumMaximize) {
        this.seleniumMaximize = seleniumMaximize;
    }

    public int getSeleniumSpeed() {
        return this.seleniumSpeed;
    }

    public void setSeleniumSpeed(int seleniumSpeed) {
        this.seleniumSpeed = seleniumSpeed;
    }

    public boolean isSeleniumNetworkTrafficEnabled() {
        return this.seleniumNetworkTrafficEnabled;
    }

    public void setSeleniumNetworkTrafficEnabled(boolean seleniumNetworkTrafficEnabled) {
        this.seleniumNetworkTrafficEnabled = seleniumNetworkTrafficEnabled;
    }

    public String getStartParameters() {
        return this.startParameters;
    }

    public void setStartParameters(String startParameters) {
        this.startParameters = startParameters;
    }

    public long getSeleniumTimeoutDefault() {
        return this.seleniumTimeoutDefault;
    }

    public void setSeleniumTimeoutDefault(long seleniumTimeoutDefault) {
        this.seleniumTimeoutDefault = seleniumTimeoutDefault;
    }

    public long getSeleniumTimeoutGui() {
        return this.seleniumTimeoutGui;
    }

    public void setSeleniumTimeoutGui(long seleniumTimeoutGui) {
        this.seleniumTimeoutGui = seleniumTimeoutGui;
    }

    public long getSeleniumTimeoutAjax() {
        return this.seleniumTimeoutAjax;
    }

    public void setSeleniumTimeoutAjax(long seleniumTimeoutAjax) {
        this.seleniumTimeoutAjax = seleniumTimeoutAjax;
    }

    public long getSeleniumTimeoutModel() {
        return this.seleniumTimeoutModel;
    }

    public void setSeleniumTimeoutModel(long seleniumTimeoutModel) {
        this.seleniumTimeoutModel = seleniumTimeoutModel;
    }

    public void setSeleniumDebug(boolean seleniumDebug) {
        this.seleniumDebug = seleniumDebug;
    }

    public boolean isSeleniumDebug() {
        return this.seleniumDebug;
    }

    public long getTimeout(GrapheneConfiguration.TimeoutType type) {
        switch (type) {
            case DEFAULT: {
                return this.seleniumTimeoutDefault;
            }
            case GUI: {
                return this.seleniumTimeoutGui;
            }
            case AJAX: {
                return this.seleniumTimeoutAjax;
            }
            case MODEL: {
                return this.seleniumTimeoutModel;
            }
        }
        throw new UnsupportedOperationException("Unable to determite wait time for given timout type: " + type);
    }

    private void initContextRoot() {
        try {
            this.contextRoot = new URI("http://localhost:8080").toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unable to set default value for contextRoot", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to set default value for contextRoot", e);
        }
    }
}

