/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.command;

import com.thoughtworks.selenium.CommandProcessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jboss.arquillian.ajocado.command.CommandContext;
import org.jboss.arquillian.ajocado.command.CommandInterceptor;
import org.jboss.arquillian.ajocado.command.CommandInterceptorException;

public class CommandContextImpl
implements CommandContext {
    private String command;
    private String[] args;
    private CommandProcessor commandProcessor;
    private Method method;
    private Iterator<CommandInterceptor> interceptors;
    private Object result;
    private int invocations = 0;

    CommandContextImpl(String command, String[] args, CommandProcessor commandProcessor, Method method, Collection<CommandInterceptor> interceptors) {
        this.command = command;
        this.method = method;
        this.args = args;
        this.commandProcessor = commandProcessor;
        this.interceptors = interceptors.iterator();
    }

    public Object invoke() throws CommandInterceptorException {
        ++this.invocations;
        int currentInvocations = this.invocations;
        if (this.interceptors.hasNext()) {
            CommandInterceptor interceptor = this.interceptors.next();
            interceptor.intercept((CommandContext)this);
            if (currentInvocations == this.invocations) {
                throw new CommandInterceptorException();
            }
            return this.result;
        }
        try {
            this.result = this.method.invoke((Object)this.commandProcessor, this.command, this.args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return this.result;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return (String[])this.args.clone();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("commandName", (Object)this.command).append("args", (Object[])this.args).toString();
    }
}

