/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework.internal;

import java.util.List;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.framework.PageExtensions;
import org.jboss.arquillian.ajocado.javascript.JavaScript;

public class PageExtensionsImpl
implements PageExtensions {
    JavaScript pageExtensions;
    final JavaScript isBodyLoaded = JavaScript.js((String)"(selenium.browserbot.getCurrentWindow() != null)  && (selenium.browserbot.getCurrentWindow().document != null)  && (selenium.browserbot.getCurrentWindow().document.body != null)");
    final JavaScript isGraphenePageUndefined = JavaScript.js((String)"Graphene === undefined || Graphene.getPage() === undefined");
    GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();

    public void install() {
        if (!this.isInstalled()) {
            this.waitForBodyLoaded();
            this.installPageExtension();
        }
    }

    public boolean isInstalled() {
        return Boolean.valueOf(this.selenium.getEval(this.isGraphenePageUndefined)) == false;
    }

    void installPageExtension() {
        this.selenium.runScript(this.pageExtensions);
    }

    void waitForBodyLoaded() {
        this.selenium.waitForCondition(this.isBodyLoaded, 30000L);
    }

    public void loadFromResources(List<String> resourceNames) {
        JavaScript extensions = null;
        for (String resourceName : resourceNames) {
            JavaScript partial = JavaScript.fromResource((String)resourceName);
            extensions = extensions == null ? partial : extensions.join(partial);
        }
        this.pageExtensions = extensions;
    }
}

