/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfigurationContext;
import org.jboss.arquillian.ajocado.waiting.Waiting;

public class WaitingProxy<T extends Waiting<T>>
implements InvocationHandler {
    GrapheneConfiguration configuration = GrapheneConfigurationContext.getProxy();
    T waiting;
    GrapheneConfiguration.TimeoutType timeoutType;

    public WaitingProxy(T waiting, GrapheneConfiguration.TimeoutType timeoutType) {
        this.waiting = waiting;
        this.timeoutType = timeoutType;
    }

    public static <T extends Waiting<T>> T create(T waiting, GrapheneConfiguration.TimeoutType timeoutType) {
        WaitingProxy<T> handler = new WaitingProxy<T>(waiting, timeoutType);
        Waiting proxy = (Waiting)Proxy.newProxyInstance(WaitingProxy.class.getClassLoader(), WaitingProxy.getInterfaces(waiting.getClass()), handler);
        return (T)proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object target = this.waiting.timeout(this.configuration.getTimeout(this.timeoutType));
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static Class<?>[] getInterfaces(Class<?> waitingClass) {
        HashSet<Class> set = new HashSet<Class>();
        LinkedList queue = new LinkedList();
        LinkedList<Class> interfaces = new LinkedList<Class>();
        queue.add(waitingClass);
        while (!queue.isEmpty()) {
            Class clazz = (Class)queue.poll();
            if (set.contains(clazz)) continue;
            set.add(clazz);
            queue.addAll(Arrays.asList(clazz.getInterfaces()));
            if (clazz.getSuperclass() == null) continue;
            queue.add(clazz.getSuperclass());
        }
        for (Class clazz : set) {
            if (!clazz.isInterface()) continue;
            interfaces.add(clazz);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

