/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.guard;

import com.thoughtworks.selenium.SeleniumException;
import org.jboss.arquillian.ajocado.command.CommandContext;
import org.jboss.arquillian.ajocado.command.CommandInterceptor;
import org.jboss.arquillian.ajocado.command.CommandInterceptorException;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfigurationContext;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.guard.GuardedCommands;
import org.jboss.arquillian.ajocado.guard.RequestGuardException;
import org.jboss.arquillian.ajocado.request.RequestType;

public class RequestGuardInterceptor
implements CommandInterceptor {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private GrapheneConfiguration configuration = GrapheneConfigurationContext.getProxy();
    private RequestType requestExpected;
    private boolean interlayed;

    public RequestGuardInterceptor(RequestType requestExpected, boolean interlayed) {
        this.requestExpected = requestExpected;
        this.interlayed = interlayed;
    }

    public void intercept(CommandContext ctx) throws CommandInterceptorException {
        String command = ctx.getCommand();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doBeforeCommand();
        }
        ctx.invoke();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doAfterCommand();
        }
    }

    public void doBeforeCommand() {
        this.selenium.getPageExtensions().install();
        this.selenium.getRequestGuard().clearRequestDone();
    }

    public void doAfterCommand() {
        long end = System.currentTimeMillis() + this.configuration.getTimeout(GrapheneConfiguration.TimeoutType.AJAX);
        RequestType lastRequestDone = RequestType.NONE;
        while (System.currentTimeMillis() <= end) {
            try {
                this.selenium.getRequestGuard().waitForRequest();
            }
            catch (SeleniumException e) {
                // empty catch block
            }
            RequestType requestDone = this.selenium.getRequestGuard().clearRequestDone();
            if (requestDone == this.requestExpected) {
                lastRequestDone = requestDone;
                break;
            }
            if (this.interlayed) {
                if (requestDone == RequestType.HTTP) {
                    this.selenium.getPageExtensions().install();
                    this.selenium.getRequestGuard().clearRequestDone();
                }
                if (requestDone == RequestType.NONE) continue;
                lastRequestDone = requestDone;
                continue;
            }
            lastRequestDone = requestDone;
            break;
        }
        if (lastRequestDone != this.requestExpected) {
            throw new RequestGuardException(this.requestExpected, lastRequestDone);
        }
    }
}

