/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class AlertEquals
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private String message;

    protected AlertEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.message);
        if (!this.selenium.isAlertPresent()) {
            return false;
        }
        String alertMessage = this.selenium.getAlert();
        if (!this.message.equals(alertMessage)) {
            throw new SeleniumException("Alert has been displayed, but the message '" + this.message + "' doesn't equal to the expected '" + alertMessage + "'");
        }
        return true;
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        Validate.notNull((Object)this.message);
        String escapedMessage = StringEscapeUtils.escapeJavaScript((String)this.message);
        return JavaScript.js((String)"selenium.isAlertPresent() && ((alertMessage = selenium.getAlert()) == '{0}'  || selenium.throwError('Alert has been displayed, but the message \\'' + alertMessage + '\\' doesn\\'t equal to the expected \\'{0}\\''))").parametrize(new Object[]{escapedMessage});
    }

    public static AlertEquals getInstance() {
        return new AlertEquals();
    }

    public AlertEquals message(String message) {
        Validate.notNull((Object)message);
        AlertEquals copy = this.copy();
        copy.message = message;
        return copy;
    }

    private AlertEquals copy() {
        AlertEquals copy = new AlertEquals();
        copy.message = this.message;
        return copy;
    }
}

