/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class ElementVisible
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected ElementVisible() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return this.selenium.isVisible(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        return JavaScript.js((String)"selenium.isVisible('{0}')").parametrize(new Object[]{escapedLocator});
    }

    public static ElementVisible getInstance() {
        return new ElementVisible();
    }

    public ElementVisible locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        ElementVisible copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementVisible copy() {
        ElementVisible copy = new ElementVisible();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

