/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class TextEquals
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;
    private String text;

    protected TextEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        Validate.notNull((Object)this.text);
        return this.selenium.getText(this.elementLocator).equals(this.text);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        String escapedText = StringEscapeUtils.escapeJavaScript((String)this.text);
        return JavaScript.js((String)"selenium.isElementPresent('{0}') && (selenium.getText('{0}') == '{1}')").parametrize(new Object[]{escapedLocator, escapedText});
    }

    public static TextEquals getInstance() {
        return new TextEquals();
    }

    public TextEquals locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        TextEquals copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    public TextEquals text(String text) {
        Validate.notNull((Object)text);
        TextEquals copy = this.copy();
        copy.text = text;
        return copy;
    }

    private TextEquals copy() {
        TextEquals copy = new TextEquals();
        copy.elementLocator = this.elementLocator;
        copy.text = this.text;
        return copy;
    }
}

