/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.locator;

import org.jboss.arquillian.ajocado.format.SimplifiedFormat;
import org.jboss.arquillian.ajocado.locator.LocationStrategy;
import org.jboss.arquillian.ajocado.locator.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocator<T extends Locator<T>>
implements Locator<T> {
    private String locator;

    public AbstractLocator(String locator) {
        if (locator == null) {
            throw new IllegalArgumentException("locator can't be null");
        }
        this.locator = locator;
    }

    @Override
    public String getRawLocator() {
        return this.locator;
    }

    @Override
    public Locator<T> format(Object ... args) {
        String newLocator = SimplifiedFormat.format(this.locator, args);
        try {
            return (Locator)this.getClass().getConstructor(String.class).newInstance(newLocator);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String inSeleniumRepresentation() {
        LocationStrategy locationStrategy = this.getLocationStrategy();
        return SimplifiedFormat.format("{0}={1}", locationStrategy.getStrategyName(), this.getRawLocator());
    }

    public String toString() {
        return this.inSeleniumRepresentation();
    }
}

