/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.guard;

import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfigurationContext;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.guard.RequestGuard;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.request.RequestType;

public class RequestGuardImpl
implements RequestGuard {
    private static final String WAIT_FOR_REQUEST = "waitForRequest";
    private static final JavaScript CLEAR_REQUEST_DONE = JavaScript.js((String)"Graphene.RequestInterceptor.clearRequestDone()");
    private static final JavaScript GET_REQUEST_DONE = JavaScript.js((String)"Graphene.RequestInterceptor.getRequestDone()");
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private GrapheneConfiguration configuration = GrapheneConfigurationContext.getProxy();

    public RequestType getRequestDone() {
        String requestDone = this.selenium.getEval(GET_REQUEST_DONE);
        return this.parseRequest(requestDone);
    }

    public RequestType clearRequestDone() {
        String lastRequest = this.selenium.getEval(CLEAR_REQUEST_DONE);
        return this.parseRequest(lastRequest);
    }

    public void waitForRequest() {
        this.selenium.doCommand(WAIT_FOR_REQUEST, Long.toString(this.configuration.getTimeout(GrapheneConfiguration.TimeoutType.AJAX)), null);
    }

    private RequestType parseRequest(String request) {
        try {
            return RequestType.valueOf((String)request);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Request was evaluated to unknown type '" + request + "'");
        }
    }
}

